/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cluster;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.apache.camel.ServiceStatus;
import org.apache.camel.cluster.CamelClusterEventListener;
import org.apache.camel.cluster.CamelClusterMember;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.cluster.CamelClusterView;
import org.apache.camel.support.cluster.AbstractCamelClusterService;
import org.apache.camel.support.cluster.AbstractCamelClusterView;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClusterServiceViewTest {
    @Test
    public void testViewEquality() throws Exception {
        TestClusterService service = new TestClusterService(UUID.randomUUID().toString());
        TestClusterView view1 = (TestClusterView)service.getView("ns1").unwrap(TestClusterView.class);
        TestClusterView view2 = (TestClusterView)service.getView("ns1").unwrap(TestClusterView.class);
        TestClusterView view3 = (TestClusterView)service.getView("ns2").unwrap(TestClusterView.class);
        Assertions.assertEquals((Object)((Object)view1), (Object)((Object)view2));
        Assertions.assertNotEquals((Object)((Object)view1), (Object)((Object)view3));
    }

    @Test
    public void testViewReferences() throws Exception {
        TestClusterService service = new TestClusterService(UUID.randomUUID().toString());
        service.start();
        TestClusterView view1 = (TestClusterView)service.getView("ns1").unwrap(TestClusterView.class);
        TestClusterView view2 = (TestClusterView)service.getView("ns1").unwrap(TestClusterView.class);
        TestClusterView view3 = (TestClusterView)service.getView("ns2").unwrap(TestClusterView.class);
        Assertions.assertEquals((Object)ServiceStatus.Started, (Object)view1.getStatus());
        Assertions.assertEquals((Object)ServiceStatus.Started, (Object)view2.getStatus());
        Assertions.assertEquals((Object)ServiceStatus.Started, (Object)view3.getStatus());
        service.releaseView((CamelClusterView)view1);
        Assertions.assertEquals((Object)ServiceStatus.Started, (Object)view1.getStatus());
        Assertions.assertEquals((Object)ServiceStatus.Started, (Object)view2.getStatus());
        Assertions.assertEquals((Object)ServiceStatus.Started, (Object)view3.getStatus());
        service.releaseView((CamelClusterView)view2);
        Assertions.assertEquals((Object)ServiceStatus.Stopped, (Object)view1.getStatus());
        Assertions.assertEquals((Object)ServiceStatus.Stopped, (Object)view2.getStatus());
        Assertions.assertEquals((Object)ServiceStatus.Started, (Object)view3.getStatus());
        service.releaseView((CamelClusterView)view3);
        TestClusterView newView1 = (TestClusterView)service.getView("ns1").unwrap(TestClusterView.class);
        TestClusterView newView2 = (TestClusterView)service.getView("ns1").unwrap(TestClusterView.class);
        Assertions.assertEquals((Object)((Object)newView1), (Object)((Object)newView2));
        Assertions.assertEquals((Object)((Object)view1), (Object)((Object)newView1));
        Assertions.assertEquals((Object)((Object)view1), (Object)((Object)newView2));
        Assertions.assertEquals((Object)ServiceStatus.Started, (Object)newView1.getStatus());
        Assertions.assertEquals((Object)ServiceStatus.Started, (Object)newView2.getStatus());
        Assertions.assertEquals((Object)ServiceStatus.Stopped, (Object)view3.getStatus());
        service.stop();
        Assertions.assertEquals((Object)ServiceStatus.Stopped, (Object)view1.getStatus());
        Assertions.assertEquals((Object)ServiceStatus.Stopped, (Object)view2.getStatus());
        Assertions.assertEquals((Object)ServiceStatus.Stopped, (Object)view3.getStatus());
        Assertions.assertEquals((Object)ServiceStatus.Stopped, (Object)newView1.getStatus());
        Assertions.assertEquals((Object)ServiceStatus.Stopped, (Object)newView2.getStatus());
    }

    @Test
    public void testViewForceOperations() throws Exception {
        TestClusterService service = new TestClusterService(UUID.randomUUID().toString());
        TestClusterView view = (TestClusterView)service.getView("ns1").unwrap(TestClusterView.class);
        Assertions.assertEquals((Object)ServiceStatus.Stopped, (Object)view.getStatus());
        service.startView(view.getNamespace());
        Assertions.assertEquals((Object)ServiceStatus.Stopped, (Object)view.getStatus());
        service.start();
        Assertions.assertEquals((Object)ServiceStatus.Started, (Object)view.getStatus());
        service.stopView(view.getNamespace());
        Assertions.assertEquals((Object)ServiceStatus.Stopped, (Object)view.getStatus());
        service.startView(view.getNamespace());
        Assertions.assertEquals((Object)ServiceStatus.Started, (Object)view.getStatus());
        service.releaseView((CamelClusterView)view);
        Assertions.assertEquals((Object)ServiceStatus.Stopped, (Object)view.getStatus());
    }

    @Test
    public void testMultipleViewListeners() throws Exception {
        TestClusterService service = new TestClusterService(UUID.randomUUID().toString());
        TestClusterView view = (TestClusterView)service.getView("ns1").unwrap(TestClusterView.class);
        int events = 1 + new Random().nextInt(10);
        HashSet results = new HashSet();
        CountDownLatch latch = new CountDownLatch(events);
        IntStream.range(0, events).forEach(i -> view.addEventListener((CamelClusterEventListener)((CamelClusterEventListener.Leadership)(v, l) -> {
            results.add(i);
            latch.countDown();
        })));
        service.start();
        view.setLeader(true);
        latch.await(10L, TimeUnit.SECONDS);
        IntStream.range(0, events).forEach(i -> Assertions.assertTrue((boolean)results.contains(i)));
    }

    @Test
    public void testLateViewListeners() throws Exception {
        TestClusterService service = new TestClusterService(UUID.randomUUID().toString());
        TestClusterView view = (TestClusterView)service.getView("ns1").unwrap(TestClusterView.class);
        int events = 1 + new Random().nextInt(10);
        HashSet results = new HashSet();
        CountDownLatch latch = new CountDownLatch(events * 2);
        IntStream.range(0, events).forEach(i -> view.addEventListener((CamelClusterEventListener)((CamelClusterEventListener.Leadership)(v, l) -> {
            results.add(i);
            latch.countDown();
        })));
        service.start();
        view.setLeader(true);
        IntStream.range(events, events * 2).forEach(i -> view.addEventListener((CamelClusterEventListener)((CamelClusterEventListener.Leadership)(v, l) -> {
            results.add(i);
            latch.countDown();
        })));
        latch.await(10L, TimeUnit.SECONDS);
        IntStream.range(0, events * 2).forEach(i -> Assertions.assertTrue((boolean)results.contains(i)));
    }

    private static class TestClusterService
    extends AbstractCamelClusterService<TestClusterView> {
        public TestClusterService(String id) {
            super(id);
        }

        protected TestClusterView createView(String namespace) {
            return new TestClusterView((CamelClusterService)this, namespace);
        }
    }

    private static class TestClusterView
    extends AbstractCamelClusterView {
        private boolean leader;

        public TestClusterView(CamelClusterService cluster, String namespace) {
            super(cluster, namespace);
        }

        public Optional<CamelClusterMember> getLeader() {
            return this.leader ? Optional.of(this.getLocalMember()) : Optional.empty();
        }

        public CamelClusterMember getLocalMember() {
            return new CamelClusterMember(){

                public boolean isLeader() {
                    return leader;
                }

                public boolean isLocal() {
                    return true;
                }

                public String getId() {
                    return this.getClusterService().getId();
                }
            };
        }

        public List<CamelClusterMember> getMembers() {
            return Collections.emptyList();
        }

        protected void doStart() {
        }

        protected void doStop() {
        }

        public boolean isLeader() {
            return this.leader;
        }

        public void setLeader(boolean leader) {
            this.leader = leader;
            if (this.isRunAllowed()) {
                this.fireLeadershipChangedEvent(this.getLeader().orElse(null));
            }
        }
    }
}

