/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cluster;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.cluster.CamelClusterMember;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.cluster.CamelClusterView;
import org.apache.camel.component.file.cluster.FileLockClusterService;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.support.cluster.AbstractCamelClusterService;
import org.apache.camel.support.cluster.AbstractCamelClusterView;
import org.apache.camel.support.cluster.ClusterServiceHelper;
import org.apache.camel.support.cluster.ClusterServiceSelectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClusterServiceSelectorTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultSelector() throws Exception {
        DefaultCamelContext context = null;
        try {
            DummyClusterService1 service1 = new DummyClusterService1();
            context = new DefaultCamelContext();
            context.addService((Object)service1);
            Optional lookup = ClusterServiceHelper.lookupService((CamelContext)context);
            Assertions.assertTrue((boolean)lookup.isPresent());
            Assertions.assertEquals((Object)((Object)service1), lookup.get());
        }
        finally {
            if (context != null) {
                context.stop();
                Assertions.assertTrue((boolean)context.isStopped());
            }
        }
    }

    @Test
    public void testDefaultSelectorFailure() throws Exception {
        DefaultCamelContext context = null;
        try {
            context = new DefaultCamelContext();
            context.addService((Object)new DummyClusterService1());
            context.addService((Object)new DummyClusterService2());
            Optional lookup = ClusterServiceHelper.lookupService((CamelContext)context);
            Assertions.assertFalse((boolean)lookup.isPresent());
        }
        finally {
            if (context != null) {
                context.stop();
                Assertions.assertTrue((boolean)context.isStopped());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectSingle() throws Exception {
        DefaultCamelContext context = null;
        try {
            DummyClusterService1 service1 = new DummyClusterService1();
            context = new DefaultCamelContext();
            context.addService((Object)service1);
            CamelClusterService.Selector selector = ClusterServiceSelectors.single();
            Optional lookup = ClusterServiceHelper.lookupService((CamelContext)context, (CamelClusterService.Selector)selector);
            Assertions.assertTrue((boolean)lookup.isPresent());
            Assertions.assertEquals((Object)((Object)service1), lookup.get());
        }
        finally {
            if (context != null) {
                context.stop();
                Assertions.assertTrue((boolean)context.isStopped());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectSingleFailure() throws Exception {
        DefaultCamelContext context = null;
        try {
            context = new DefaultCamelContext();
            context.addService((Object)new DummyClusterService1());
            context.addService((Object)new DummyClusterService2());
            CamelClusterService.Selector selector = ClusterServiceSelectors.single();
            Optional lookup = ClusterServiceHelper.lookupService((CamelContext)context, (CamelClusterService.Selector)selector);
            Assertions.assertFalse((boolean)lookup.isPresent());
        }
        finally {
            if (context != null) {
                context.stop();
                Assertions.assertTrue((boolean)context.isStopped());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectFirst() throws Exception {
        DefaultCamelContext context = null;
        try {
            context = new DefaultCamelContext();
            context.addService((Object)new DummyClusterService1());
            context.addService((Object)new DummyClusterService2());
            CamelClusterService.Selector selector = ClusterServiceSelectors.first();
            Optional lookup = ClusterServiceHelper.lookupService((CamelContext)context, (CamelClusterService.Selector)selector);
            Assertions.assertTrue((boolean)lookup.isPresent());
        }
        finally {
            if (context != null) {
                context.stop();
                Assertions.assertTrue((boolean)context.isStopped());
            }
        }
    }

    @Test
    public void testSelectByType() throws Exception {
        DefaultCamelContext context = null;
        try {
            context = new DefaultCamelContext();
            context.addService((Object)new DummyClusterService1());
            context.addService((Object)new DummyClusterService2());
            Assertions.assertTrue((boolean)ClusterServiceHelper.lookupService((CamelContext)context, (CamelClusterService.Selector)ClusterServiceSelectors.type(DummyClusterService1.class)).isPresent());
            Assertions.assertTrue((boolean)ClusterServiceHelper.lookupService((CamelContext)context, (CamelClusterService.Selector)ClusterServiceSelectors.type(DummyClusterService2.class)).isPresent());
            Assertions.assertFalse((boolean)ClusterServiceHelper.lookupService((CamelContext)context, (CamelClusterService.Selector)ClusterServiceSelectors.type(FileLockClusterService.class)).isPresent());
        }
        finally {
            if (context != null) {
                context.stop();
                Assertions.assertTrue((boolean)context.isStopped());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectByAttribute() throws Exception {
        DefaultCamelContext context = null;
        try {
            DummyClusterService1 service1 = new DummyClusterService1();
            service1.setAttribute("service.type", "zookeeper");
            DummyClusterService2 service2 = new DummyClusterService2();
            service2.setAttribute("service.type", "file");
            context = new DefaultCamelContext();
            context.addService((Object)service1);
            context.addService((Object)service2);
            Optional lookup = ClusterServiceHelper.lookupService((CamelContext)context, (CamelClusterService.Selector)ClusterServiceSelectors.attribute((String)"service.type", (Object)"zookeeper"));
            Assertions.assertTrue((boolean)lookup.isPresent());
            Assertions.assertEquals((Object)((Object)service1), lookup.get());
            lookup = ClusterServiceHelper.lookupService((CamelContext)context, (CamelClusterService.Selector)ClusterServiceSelectors.attribute((String)"service.type", (Object)"file"));
            Assertions.assertTrue((boolean)lookup.isPresent());
            Assertions.assertEquals((Object)((Object)service2), lookup.get());
            lookup = ClusterServiceHelper.lookupService((CamelContext)context, (CamelClusterService.Selector)ClusterServiceSelectors.attribute((String)"service.type", (Object)"consul"));
            Assertions.assertFalse((boolean)lookup.isPresent());
        }
        finally {
            if (context != null) {
                context.stop();
                Assertions.assertTrue((boolean)context.isStopped());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectByOrder() throws Exception {
        DefaultCamelContext context = null;
        try {
            DummyClusterService1 service1 = new DummyClusterService1();
            service1.setOrder(1);
            DummyClusterService2 service2 = new DummyClusterService2();
            service2.setOrder(0);
            context = new DefaultCamelContext();
            context.addService((Object)service1);
            context.addService((Object)service2);
            CamelClusterService.Selector selector = ClusterServiceSelectors.order();
            Optional lookup = ClusterServiceHelper.lookupService((CamelContext)context, (CamelClusterService.Selector)selector);
            Assertions.assertTrue((boolean)lookup.isPresent());
            Assertions.assertEquals((Object)((Object)service2), lookup.get());
        }
        finally {
            if (context != null) {
                context.stop();
                Assertions.assertTrue((boolean)context.isStopped());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectByOrderFailure() throws Exception {
        DefaultCamelContext context = null;
        try {
            DummyClusterService1 service1 = new DummyClusterService1();
            service1.setOrder(1);
            DummyClusterService2 service2 = new DummyClusterService2();
            service2.setOrder(0);
            DummyClusterService2 service3 = new DummyClusterService2();
            service3.setOrder(0);
            context = new DefaultCamelContext();
            context.addService((Object)service1);
            context.addService((Object)service2);
            context.addService((Object)service3);
            CamelClusterService.Selector selector = ClusterServiceSelectors.order();
            Optional lookup = ClusterServiceHelper.lookupService((CamelContext)context, (CamelClusterService.Selector)selector);
            Assertions.assertFalse((boolean)lookup.isPresent());
        }
        finally {
            if (context != null) {
                context.stop();
                Assertions.assertTrue((boolean)context.isStopped());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMandatoryLookup() throws Exception {
        DefaultCamelContext context = null;
        try {
            DummyClusterService1 service1 = new DummyClusterService1();
            context = new DefaultCamelContext();
            context.addService((Object)service1);
            CamelClusterService.Selector selector = ClusterServiceSelectors.single();
            CamelClusterService lookup = ClusterServiceHelper.mandatoryLookupService((CamelContext)context, (CamelClusterService.Selector)selector);
            Assertions.assertNotNull((Object)lookup);
            Assertions.assertEquals((Object)((Object)service1), (Object)lookup);
        }
        finally {
            if (context != null) {
                context.stop();
                Assertions.assertTrue((boolean)context.isStopped());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMandatoryLookupWithoutSelector() throws Exception {
        DefaultCamelContext context = null;
        try {
            DummyClusterService1 service1 = new DummyClusterService1();
            context = new DefaultCamelContext();
            context.addService((Object)service1);
            CamelClusterService lookup = ClusterServiceHelper.mandatoryLookupService((CamelContext)context);
            Assertions.assertNotNull((Object)lookup);
            Assertions.assertEquals((Object)((Object)service1), (Object)lookup);
        }
        finally {
            if (context != null) {
                context.stop();
                Assertions.assertTrue((boolean)context.isStopped());
            }
        }
    }

    @Test
    public void testMandatoryLookupFailure() {
        DefaultCamelContext context = null;
        try {
            DefaultCamelContext ctx = context = new DefaultCamelContext();
            Assertions.assertThrows(IllegalStateException.class, () -> ClusterServiceSelectorTest.lambda$testMandatoryLookupFailure$0((CamelContext)ctx));
        }
        finally {
            if (context != null) {
                context.stop();
                Assertions.assertTrue((boolean)context.isStopped());
            }
        }
    }

    @Test
    public void testMandatoryLookupFailureWithoutSelector() {
        DefaultCamelContext context = null;
        try {
            DefaultCamelContext ctx = context = new DefaultCamelContext();
            Assertions.assertThrows(IllegalStateException.class, () -> ClusterServiceSelectorTest.lambda$testMandatoryLookupFailureWithoutSelector$1((CamelContext)ctx));
        }
        finally {
            if (context != null) {
                context.stop();
                Assertions.assertTrue((boolean)context.isStopped());
            }
        }
    }

    private static /* synthetic */ void lambda$testMandatoryLookupFailureWithoutSelector$1(CamelContext ctx) throws Throwable {
        ClusterServiceHelper.mandatoryLookupService((CamelContext)ctx);
    }

    private static /* synthetic */ void lambda$testMandatoryLookupFailure$0(CamelContext ctx) throws Throwable {
        ClusterServiceHelper.mandatoryLookupService((CamelContext)ctx, (CamelClusterService.Selector)ClusterServiceSelectors.single());
    }

    private static final class DummyClusterService1
    extends AbstractCamelClusterService {
        protected CamelClusterView createView(String namespace) {
            return new DummyClusterServiceView((CamelClusterService)this, namespace);
        }
    }

    private static final class DummyClusterService2
    extends AbstractCamelClusterService {
        protected CamelClusterView createView(String namespace) {
            return new DummyClusterServiceView((CamelClusterService)this, namespace);
        }
    }

    private static final class DummyClusterServiceView
    extends AbstractCamelClusterView {
        public DummyClusterServiceView(CamelClusterService cluster, String namespace) {
            super(cluster, namespace);
        }

        public Optional<CamelClusterMember> getLeader() {
            return Optional.empty();
        }

        public CamelClusterMember getLocalMember() {
            return new DummyClusterServiceMember(false, true);
        }

        public List<CamelClusterMember> getMembers() {
            return Collections.emptyList();
        }

        private final class DummyClusterServiceMember
        implements CamelClusterMember {
            private final boolean leader;
            private final boolean local;

            public DummyClusterServiceMember(boolean leader, boolean local) {
                this.leader = leader;
                this.local = local;
            }

            public boolean isLeader() {
                return this.leader;
            }

            public boolean isLocal() {
                return this.local;
            }

            public String getId() {
                return DummyClusterServiceView.this.getClusterService().getId();
            }
        }
    }
}

