/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.camel.CamelContext;
import org.apache.camel.catalog.RuntimeCamelCatalog;
import org.apache.camel.catalog.impl.DefaultRuntimeCamelCatalog;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.util.CollectionHelper;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class RuntimeCamelCatalogTest {
    static RuntimeCamelCatalog catalog;

    @BeforeAll
    public static void createCamelCatalog() {
        catalog = new DefaultRuntimeCamelCatalog();
        catalog.setCamelContext((CamelContext)new DefaultCamelContext());
    }

    @AfterAll
    public static void cleanCamelCatalog() {
        catalog = null;
    }

    @Test
    public void testAsEndpointUriMapFile() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("directoryName", "src/data/inbox");
        map.put("noop", "true");
        map.put("delay", "5000");
        String uri = catalog.asEndpointUri("file", map, true);
        Assertions.assertEquals((Object)"file:src/data/inbox?delay=5000&noop=true", (Object)uri);
    }

    @Test
    public void testAsEndpointUriTimer() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("timerName", "foo");
        map.put("period", "5000");
        String uri = catalog.asEndpointUri("timer", map, true);
        Assertions.assertEquals((Object)"timer:foo?period=5000", (Object)uri);
    }

    @Test
    public void testAsEndpointUriPropertiesPlaceholders() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("timerName", "foo");
        map.put("period", "{{howoften}}");
        map.put("repeatCount", "5");
        String uri = catalog.asEndpointUri("timer", map, true);
        Assertions.assertEquals((Object)"timer:foo?period=%7B%7Bhowoften%7D%7D&repeatCount=5", (Object)uri);
        uri = catalog.asEndpointUri("timer", map, false);
        Assertions.assertEquals((Object)"timer:foo?period={{howoften}}&repeatCount=5", (Object)uri);
    }

    @Test
    public void testAsEndpointUriBeanLookup() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("resourceUri", "foo.xslt");
        map.put("converter", "#myConverter");
        String uri = catalog.asEndpointUri("xslt", map, true);
        Assertions.assertEquals((Object)"xslt:foo.xslt?converter=%23myConverter", (Object)uri);
        uri = catalog.asEndpointUri("xslt", map, false);
        Assertions.assertEquals((Object)"xslt:foo.xslt?converter=#myConverter", (Object)uri);
    }

    @Test
    public void testEndpointPropertiesPlaceholders() throws Exception {
        Map map = catalog.endpointProperties("timer:foo?period={{howoften}}&repeatCount=5");
        Assertions.assertNotNull((Object)map);
        Assertions.assertEquals((int)3, (int)map.size());
        Assertions.assertEquals((Object)"foo", map.get("timerName"));
        Assertions.assertEquals((Object)"{{howoften}}", map.get("period"));
        Assertions.assertEquals((Object)"5", map.get("repeatCount"));
    }

    @Test
    public void testAsEndpointUriLog() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("loggerName", "foo");
        map.put("loggerLevel", "WARN");
        map.put("multiline", "true");
        map.put("showAll", "true");
        map.put("showBody", "false");
        map.put("showBodyType", "false");
        map.put("showExchangePattern", "false");
        map.put("style", "Tab");
        Assertions.assertEquals((Object)"log:foo?loggerLevel=WARN&multiline=true&showAll=true&style=Tab", (Object)catalog.asEndpointUri("log", map, false));
    }

    @Test
    public void testAsEndpointUriSecrets() throws Exception {
        DefaultRuntimeCamelCatalog catalog = new DefaultRuntimeCamelCatalog(){

            public ComponentModel componentModel(String name) {
                ComponentModel model = super.componentModel(name);
                if (model != null && "timer".equals(name)) {
                    model.getEndpointParameterOptions().stream().filter(o -> Objects.equals(o.getName(), "period")).forEach(o -> o.setSecret(true));
                    model.getEndpointPathOptions().stream().filter(o -> Objects.equals(o.getName(), "timerName")).forEach(o -> o.setDefaultValue((Object)"defaultName"));
                }
                return model;
            }
        };
        catalog.setCamelContext((CamelContext)new DefaultCamelContext());
        Assertions.assertEquals((Object)"timer:foo?period=RAW(5000)", (Object)catalog.asEndpointUri("timer", CollectionHelper.mapOf((Object)"timerName", (Object)"foo", (Object[])new Object[]{"period", "5000"}), false));
        Assertions.assertEquals((Object)"timer:defaultName?period=RAW(5000)", (Object)catalog.asEndpointUri("timer", CollectionHelper.mapOf((Object)"period", (Object)"5000", (Object[])new Object[0]), false));
    }

    @Test
    public void testAsEndpointUriLogShort() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("loggerName", "foo");
        map.put("loggerLevel", "DEBUG");
        Assertions.assertEquals((Object)"log:foo?loggerLevel=DEBUG", (Object)catalog.asEndpointUri("log", map, false));
    }

    @Test
    public void testAsEndpointUriWithplaceholder() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "foo");
        map.put("blockWhenFull", "{{block}}");
        Assertions.assertEquals((Object)"seda:foo?blockWhenFull={{block}}", (Object)catalog.asEndpointUri("seda", map, false));
    }

    @Test
    public void testEndpointPropertiesSedaRequired() throws Exception {
        Map map = catalog.endpointProperties("seda:foo");
        Assertions.assertNotNull((Object)map);
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertEquals((Object)"foo", map.get("name"));
        map = catalog.endpointProperties("seda:foo?blockWhenFull=true");
        Assertions.assertNotNull((Object)map);
        Assertions.assertEquals((int)2, (int)map.size());
        Assertions.assertEquals((Object)"foo", map.get("name"));
        Assertions.assertEquals((Object)"true", map.get("blockWhenFull"));
    }
}

