/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog;

import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CustomEndpointUriFactoryTest
extends ContextTestSupport {
    @Test
    public void testCustomAssemble() throws Exception {
        MyAssembler assembler = new MyAssembler();
        assembler.setCamelContext((CamelContext)this.context);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", "foo");
        params.put("amount", "123");
        params.put("port", 4444);
        params.put("verbose", true);
        String uri = assembler.buildUri("acme", params);
        Assertions.assertEquals((Object)"acme:foo:4444?amount=123&verbose=true", (Object)uri);
    }

    @Test
    public void testCustomUriFactoryRegistry() throws Exception {
        MyAssembler assembler = new MyAssembler();
        this.context.getRegistry().bind("myAssembler", (Object)assembler);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", "foo");
        params.put("amount", "123");
        params.put("port", 4444);
        params.put("verbose", true);
        assembler = this.context.getCamelContextExtension().getEndpointUriFactory("acme");
        String uri = assembler.buildUri("acme", params);
        Assertions.assertEquals((Object)"acme:foo:4444?amount=123&verbose=true", (Object)uri);
    }

    @Test
    public void testCustomAssembleUnsorted() throws Exception {
        MyAssembler assembler = new MyAssembler();
        assembler.setCamelContext((CamelContext)this.context);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("name", "foo");
        params.put("verbose", false);
        params.put("port", 4444);
        params.put("amount", "123");
        String uri = assembler.buildUri("acme", params);
        Assertions.assertEquals((Object)"acme:foo:4444?amount=123&verbose=false", (Object)uri);
    }

    @Test
    public void testCustomAssembleNoMandatory() {
        MyAssembler assembler = new MyAssembler();
        assembler.setCamelContext((CamelContext)this.context);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("verbose", false);
        params.put("port", 4444);
        params.put("amount", "123");
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> assembler.buildUri("acme", params), (String)"Should have thrown an exception");
        Assertions.assertEquals((Object)"Option name is required when creating endpoint uri with syntax acme:name:port", (Object)e.getMessage());
    }

    @Test
    public void testCustomAssembleDefault() throws Exception {
        MyAssembler assembler = new MyAssembler();
        assembler.setCamelContext((CamelContext)this.context);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("name", "bar");
        params.put("verbose", false);
        params.put("amount", "123");
        String uri = assembler.buildUri("acme", params);
        Assertions.assertEquals((Object)"acme:bar?amount=123&verbose=false", (Object)uri);
    }

    @Test
    public void testCustomAssembleComplex() throws Exception {
        MySecondAssembler assembler = new MySecondAssembler();
        assembler.setCamelContext((CamelContext)this.context);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("name", "bar");
        params.put("path", "moes");
        params.put("verbose", true);
        params.put("amount", "123");
        String uri = assembler.buildUri("acme2", params);
        Assertions.assertEquals((Object)"acme2:bar/moes?amount=123&verbose=true", (Object)uri);
    }

    @Test
    public void testCustomAssembleComplexPort() throws Exception {
        MySecondAssembler assembler = new MySecondAssembler();
        assembler.setCamelContext((CamelContext)this.context);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("name", "bar");
        params.put("path", "moes");
        params.put("port", "4444");
        params.put("verbose", true);
        params.put("amount", "123");
        String uri = assembler.buildUri("acme2", params);
        Assertions.assertEquals((Object)"acme2:bar/moes:4444?amount=123&verbose=true", (Object)uri);
    }

    @Test
    public void testCustomAssembleComplexNoPath() throws Exception {
        MySecondAssembler assembler = new MySecondAssembler();
        assembler.setCamelContext((CamelContext)this.context);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("name", "bar");
        params.put("port", "4444");
        params.put("verbose", true);
        params.put("amount", "123");
        String uri = assembler.buildUri("acme2", params);
        Assertions.assertEquals((Object)"acme2:bar:4444?amount=123&verbose=true", (Object)uri);
    }

    @Test
    public void testCustomAssembleComplexNoPathNoPort() throws Exception {
        MySecondAssembler assembler = new MySecondAssembler();
        assembler.setCamelContext((CamelContext)this.context);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("name", "bar");
        params.put("verbose", true);
        params.put("amount", "123");
        String uri = assembler.buildUri("acme2", params);
        Assertions.assertEquals((Object)"acme2:bar?amount=123&verbose=true", (Object)uri);
    }

    @Test
    public void testJms() throws Exception {
        MyJmsAssembler assembler = new MyJmsAssembler();
        assembler.setCamelContext((CamelContext)this.context);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("destinationName", "foo");
        params.put("destinationType", "topic");
        params.put("deliveryPersistent", true);
        String uri = assembler.buildUri("jms2", params);
        Assertions.assertEquals((Object)"jms2:topic:foo?deliveryPersistent=true", (Object)uri);
    }

    @Test
    public void testJmsMatchDefault() throws Exception {
        MyJmsAssembler assembler = new MyJmsAssembler();
        assembler.setCamelContext((CamelContext)this.context);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("destinationName", "foo");
        params.put("destinationType", "queue");
        params.put("deliveryPersistent", true);
        String uri = assembler.buildUri("jms2", params);
        Assertions.assertEquals((Object)"jms2:queue:foo?deliveryPersistent=true", (Object)uri);
    }

    @Test
    public void testJmsNoDefault() throws Exception {
        MyJmsAssembler assembler = new MyJmsAssembler();
        assembler.setCamelContext((CamelContext)this.context);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("destinationName", "foo");
        params.put("deliveryPersistent", true);
        String uri = assembler.buildUri("jms2", params);
        Assertions.assertEquals((Object)"jms2:foo?deliveryPersistent=true", (Object)uri);
    }

    @Test
    public void testCQLAssembler() throws Exception {
        MyCQLAssembler assembler = new MyCQLAssembler();
        assembler.setCamelContext((CamelContext)this.context);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("host", "localhost");
        params.put("keyspace", "test");
        params.put("cql", "insert into test_data(id, text) values (now(), ?)");
        Assertions.assertEquals((Object)"cql:localhost/test?cql=insert+into+test_data%28id%2C+text%29+values+%28now%28%29%2C+%3F%29", (Object)assembler.buildUri("cql", new LinkedHashMap(params)));
        Assertions.assertEquals((Object)"cql:localhost/test?cql=insert+into+test_data%28id%2C+text%29+values+%28now%28%29%2C+%3F%29", (Object)assembler.buildUri("cql", new LinkedHashMap(params), true));
        Assertions.assertEquals((Object)"cql:localhost/test?cql=insert into test_data(id, text) values (now(), ?)", (Object)assembler.buildUri("cql", new LinkedHashMap(params), false));
    }

    @Test
    public void testCQLWithPlus() throws Exception {
        MyCQLAssembler assembler = new MyCQLAssembler();
        assembler.setCamelContext((CamelContext)this.context);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("host", "localhost");
        params.put("keyspace", "test");
        params.put("cql", "add(4 + 5)");
        Assertions.assertEquals((Object)"cql:localhost/test?cql=add%284+%2B+5%29", (Object)assembler.buildUri("cql", new LinkedHashMap(params)));
        Assertions.assertEquals((Object)"cql:localhost/test?cql=add%284+%2B+5%29", (Object)assembler.buildUri("cql", new LinkedHashMap(params), true));
        Assertions.assertEquals((Object)"cql:localhost/test?cql=add(4 + 5)", (Object)assembler.buildUri("cql", new LinkedHashMap(params), false));
    }

    @Test
    public void testJmsSecrets() throws Exception {
        MyJmsxAssembler assembler = new MyJmsxAssembler();
        assembler.setCamelContext((CamelContext)this.context);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("destinationName", "foo");
        params.put("deliveryPersistent", true);
        params.put("username", "usr");
        params.put("password", "pwd");
        String uri = assembler.buildUri("jmsx", params);
        Assertions.assertEquals((Object)"jmsx:foo?deliveryPersistent=true&password=RAW(pwd)&username=RAW(usr)", (Object)uri);
    }

    private static class MyAssembler
    extends EndpointUriFactorySupport
    implements EndpointUriFactory {
        private static final String SYNTAX = "acme:name:port";

        private MyAssembler() {
        }

        public boolean isEnabled(String scheme) {
            return "acme".equals(scheme);
        }

        public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
            String uri = SYNTAX;
            uri = this.buildPathParameter(SYNTAX, uri, "name", null, true, properties);
            uri = this.buildPathParameter(SYNTAX, uri, "port", 8080, false, properties);
            uri = this.buildQueryParameters(uri, properties, encode);
            return uri;
        }

        public Set<String> propertyNames() {
            return Collections.emptySet();
        }

        public Set<String> secretPropertyNames() {
            return Collections.emptySet();
        }

        public Set<String> multiValuePrefixes() {
            return Collections.emptySet();
        }

        public boolean isLenientProperties() {
            return false;
        }
    }

    private static class MySecondAssembler
    extends EndpointUriFactorySupport
    implements EndpointUriFactory {
        private static final String SYNTAX = "acme2:name/path:port";

        private MySecondAssembler() {
        }

        public boolean isEnabled(String scheme) {
            return "acme2".equals(scheme);
        }

        public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
            String uri = SYNTAX;
            uri = this.buildPathParameter(SYNTAX, uri, "name", null, true, properties);
            uri = this.buildPathParameter(SYNTAX, uri, "path", null, false, properties);
            uri = this.buildPathParameter(SYNTAX, uri, "port", 8080, false, properties);
            uri = this.buildQueryParameters(uri, properties, encode);
            return uri;
        }

        public Set<String> propertyNames() {
            return Collections.emptySet();
        }

        public Set<String> secretPropertyNames() {
            return Collections.emptySet();
        }

        public Set<String> multiValuePrefixes() {
            return Collections.emptySet();
        }

        public boolean isLenientProperties() {
            return false;
        }
    }

    private static class MyJmsAssembler
    extends EndpointUriFactorySupport
    implements EndpointUriFactory {
        private static final String SYNTAX = "jms2:destinationType:destinationName";

        private MyJmsAssembler() {
        }

        public boolean isEnabled(String scheme) {
            return "jms2".equals(scheme);
        }

        public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
            String uri = SYNTAX;
            uri = this.buildPathParameter(SYNTAX, uri, "destinationType", "queue", false, properties);
            uri = this.buildPathParameter(SYNTAX, uri, "destinationName", null, true, properties);
            uri = this.buildQueryParameters(uri, properties, encode);
            return uri;
        }

        public Set<String> propertyNames() {
            return Collections.emptySet();
        }

        public Set<String> secretPropertyNames() {
            return Collections.emptySet();
        }

        public Set<String> multiValuePrefixes() {
            return Collections.emptySet();
        }

        public boolean isLenientProperties() {
            return false;
        }
    }

    private static class MyCQLAssembler
    extends EndpointUriFactorySupport
    implements EndpointUriFactory {
        private static final String SYNTAX = "cql:host/keyspace";

        private MyCQLAssembler() {
        }

        public boolean isEnabled(String scheme) {
            return "cql".equals(scheme);
        }

        public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
            String uri = SYNTAX;
            uri = this.buildPathParameter(SYNTAX, uri, "host", null, true, properties);
            uri = this.buildPathParameter(SYNTAX, uri, "keyspace", null, true, properties);
            uri = this.buildQueryParameters(uri, properties, encode);
            return uri;
        }

        public Set<String> propertyNames() {
            return Collections.emptySet();
        }

        public Set<String> secretPropertyNames() {
            return Collections.emptySet();
        }

        public Set<String> multiValuePrefixes() {
            return Collections.emptySet();
        }

        public boolean isLenientProperties() {
            return false;
        }
    }

    private static class MyJmsxAssembler
    extends EndpointUriFactorySupport
    implements EndpointUriFactory {
        private static final String SYNTAX = "jmsx:destinationType:destinationName";

        private MyJmsxAssembler() {
        }

        public boolean isEnabled(String scheme) {
            return "jmsx".equals(scheme);
        }

        public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
            String uri = SYNTAX;
            uri = this.buildPathParameter(SYNTAX, uri, "destinationType", "queue", false, properties);
            uri = this.buildPathParameter(SYNTAX, uri, "destinationName", null, true, properties);
            uri = this.buildQueryParameters(uri, properties, encode);
            return uri;
        }

        public Set<String> propertyNames() {
            return new HashSet<String>(Arrays.asList("destinationType", "destinationName", "username", "password"));
        }

        public Set<String> secretPropertyNames() {
            return new HashSet<String>(Arrays.asList("username", "password"));
        }

        public Set<String> multiValuePrefixes() {
            return Collections.emptySet();
        }

        public boolean isLenientProperties() {
            return false;
        }
    }
}

