/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.CamelContext;
import org.apache.camel.component.xslt.XsltUriResolver;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.util.ObjectHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XsltUriResolverTest {
    @Test
    public void testResolveUriUsingClasspath() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        XsltUriResolver xsltUriResolver = new XsltUriResolver((CamelContext)context, "classpath:xslt/staff/staff.xsl");
        Source source = xsltUriResolver.resolve("../../xslt/common/staff_template.xsl", "classpath:xslt/staff/staff.xsl");
        Assertions.assertNotNull((Object)source);
        Assertions.assertEquals((Object)"classpath:xslt/common/staff_template.xsl", (Object)source.getSystemId());
    }

    @Test
    public void testResolveUriUsingRef() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        String staffTemplateXsl = XsltUriResolverTest.readFileFromClasspathAsString("xslt/common/staff_template.xsl");
        context.getRegistry().bind("staffTemplateXsl", (Object)staffTemplateXsl);
        XsltUriResolver xsltUriResolver = new XsltUriResolver((CamelContext)context, "classpath:xslt/staff/staff.xsl");
        Source source = xsltUriResolver.resolve("ref:staffTemplateXsl", "classpath:xslt/staff/staff.xsl");
        Assertions.assertNotNull((Object)source);
        Assertions.assertEquals((Object)"ref:staffTemplateXsl", (Object)source.getSystemId());
        Assertions.assertArrayEquals((byte[])((StreamSource)source).getInputStream().readAllBytes(), (byte[])staffTemplateXsl.getBytes());
    }

    private static String readFileFromClasspathAsString(String path) throws IOException {
        try (InputStream is = XsltUriResolverTest.class.getClassLoader().getResourceAsStream(path);){
            ObjectHelper.notNull((Object)is, (String)"is");
            String string = new String(is.readAllBytes(), StandardCharsets.UTF_8);
            return string;
        }
    }
}

