/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.component.xslt.XsltBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XsltOutputFileTest
extends ContextTestSupport {
    @Test
    public void testXsltOutputFile() throws Exception {
        Files.createDirectories(this.testDirectory(), new FileAttribute[0]);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>"});
        mock.expectedFileExists(this.testFile("xsltme.xml"));
        ((MockValueBuilder)mock.message(0).body()).isInstanceOf(File.class);
        this.template.sendBodyAndHeader("direct:start", (Object)"<hello>world!</hello>", "CamelXsltFileName", (Object)this.testFile("xsltme.xml").toString());
        mock.assertIsSatisfied();
    }

    @Test
    public void testXsltOutputFileMissingHeader() {
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("direct:start", (Object)"<hello>world!</hello>"), (String)"Should thrown exception");
        NoSuchHeaderException nshe = XsltOutputFileTest.assertIsInstanceOf(NoSuchHeaderException.class, e.getCause());
        Assertions.assertEquals((Object)"CamelXsltFileName", (Object)nshe.getHeaderName());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() throws Exception {
                URL styleSheet = ((Object)((Object)this)).getClass().getResource("example.xsl");
                ((RouteDefinition)this.from("direct:start").process((Processor)XsltBuilder.xslt((URL)styleSheet).outputFile())).to("mock:result");
            }
        };
    }
}

