/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.sax.SAXSource;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExpectedBodyTypeException;
import org.apache.camel.component.xslt.StreamResultHandlerFactory;
import org.apache.camel.component.xslt.XsltBuilder;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.UnitOfWorkHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class XsltBuilderTest
extends ContextTestSupport {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        Files.createDirectories(this.testDirectory(), new FileAttribute[0]);
    }

    @Test
    public void testXsltUrl() throws Exception {
        URL styleSheet = this.getClass().getResource("example.xsl");
        XsltBuilder builder = XsltBuilder.xslt((URL)styleSheet);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"<hello>world!</hello>");
        builder.process((Exchange)exchange);
        Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>", (Object)exchange.getMessage().getBody());
    }

    @Test
    public void testXsltTransformerUrl() throws Exception {
        URL styleSheet = this.getClass().getResource("example.xsl");
        XsltBuilder builder = new XsltBuilder();
        builder.setTransformerURL(styleSheet);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"<hello>world!</hello>");
        builder.process((Exchange)exchange);
        Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>", (Object)exchange.getMessage().getBody());
    }

    @Test
    public void testXsltFile() throws Exception {
        File styleSheet = new File("src/test/resources/org/apache/camel/builder/xml/example.xsl");
        XsltBuilder builder = XsltBuilder.xslt((File)styleSheet);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"<hello>world!</hello>");
        builder.process((Exchange)exchange);
        Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>", (Object)exchange.getMessage().getBody());
    }

    @Test
    public void testXsltTransformerFile() throws Exception {
        File styleSheet = new File("src/test/resources/org/apache/camel/builder/xml/example.xsl");
        XsltBuilder builder = new XsltBuilder();
        builder.setTransformerFile(styleSheet);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"<hello>world!</hello>");
        builder.process((Exchange)exchange);
        Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>", (Object)exchange.getMessage().getBody());
    }

    @Test
    public void testXsltInputStream() throws Exception {
        File styleSheet = new File("src/test/resources/org/apache/camel/builder/xml/example.xsl");
        XsltBuilder builder = XsltBuilder.xslt((InputStream)Files.newInputStream(Paths.get(styleSheet.getAbsolutePath(), new String[0]), new OpenOption[0]));
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"<hello>world!</hello>");
        builder.process((Exchange)exchange);
        Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>", (Object)exchange.getMessage().getBody());
    }

    @Test
    public void testXsltTransformerInputStream() throws Exception {
        File styleSheet = new File("src/test/resources/org/apache/camel/builder/xml/example.xsl");
        XsltBuilder builder = new XsltBuilder();
        builder.setTransformerInputStream(Files.newInputStream(Paths.get(styleSheet.getAbsolutePath(), new String[0]), new OpenOption[0]));
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"<hello>world!</hello>");
        builder.process((Exchange)exchange);
        Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>", (Object)exchange.getMessage().getBody());
    }

    @Test
    public void testXsltSource() throws Exception {
        File file = new File("src/test/resources/org/apache/camel/builder/xml/example.xsl");
        SAXSource styleSheet = new SAXSource(new InputSource(Files.newInputStream(Paths.get(file.getAbsolutePath(), new String[0]), new OpenOption[0])));
        XsltBuilder builder = XsltBuilder.xslt((Source)styleSheet);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"<hello>world!</hello>");
        builder.process((Exchange)exchange);
        Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>", (Object)exchange.getMessage().getBody());
    }

    @Test
    public void testXsltTemplates() throws Exception {
        File file = new File("src/test/resources/org/apache/camel/builder/xml/example.xsl");
        SAXSource source = new SAXSource(new InputSource(Files.newInputStream(Paths.get(file.getAbsolutePath(), new String[0]), new OpenOption[0])));
        XmlConverter converter = new XmlConverter();
        Templates styleSheet = converter.getTransformerFactory().newTemplates(source);
        XsltBuilder builder = XsltBuilder.xslt((Templates)styleSheet);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"<hello>world!</hello>");
        builder.process((Exchange)exchange);
        Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>", (Object)exchange.getMessage().getBody());
    }

    @Test
    public void testXsltOutputString() throws Exception {
        URL styleSheet = this.getClass().getResource("example.xsl");
        XsltBuilder builder = XsltBuilder.xslt((URL)styleSheet).outputString();
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"<hello>world!</hello>");
        builder.process((Exchange)exchange);
        XsltBuilderTest.assertIsInstanceOf(String.class, exchange.getMessage().getBody());
        Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>", (Object)exchange.getMessage().getBody());
    }

    @Test
    public void testXsltOutputBytes() throws Exception {
        URL styleSheet = this.getClass().getResource("example.xsl");
        XsltBuilder builder = XsltBuilder.xslt((URL)styleSheet).outputBytes();
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"<hello>world!</hello>");
        builder.process((Exchange)exchange);
        XsltBuilderTest.assertIsInstanceOf(byte[].class, exchange.getMessage().getBody());
        Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>", (Object)exchange.getMessage().getBody(String.class));
    }

    @Test
    public void testXsltOutputDOM() throws Exception {
        URL styleSheet = this.getClass().getResource("example.xsl");
        XsltBuilder builder = XsltBuilder.xslt((URL)styleSheet).outputDOM();
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"<hello>world!</hello>");
        builder.process((Exchange)exchange);
        XsltBuilderTest.assertIsInstanceOf(Document.class, exchange.getMessage().getBody());
        Assertions.assertEquals((Object)"<goodbye>world!</goodbye>", (Object)exchange.getMessage().getBody(String.class));
    }

    @Test
    public void testXsltOutputFile() throws Exception {
        URL styleSheet = this.getClass().getResource("example.xsl");
        XsltBuilder builder = XsltBuilder.xslt((URL)styleSheet).outputFile();
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"<hello>world!</hello>");
        exchange.getIn().setHeader("CamelXsltFileName", (Object)this.testFile("xsltout.xml").toString());
        builder.process((Exchange)exchange);
        XsltBuilderTest.assertIsInstanceOf(File.class, exchange.getMessage().getBody());
        XsltBuilderTest.assertFileExists(this.testFile("xsltout.xml"));
        String body = (String)exchange.getMessage().getBody(String.class);
        Assertions.assertTrue((boolean)body.endsWith("<goodbye>world!</goodbye>"));
    }

    @Test
    public void testXsltOutputFileDelete() throws Exception {
        URL styleSheet = this.getClass().getResource("example.xsl");
        XsltBuilder builder = XsltBuilder.xslt((URL)styleSheet).outputFile().deleteOutputFile();
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"<hello>world!</hello>");
        exchange.getIn().setHeader("CamelXsltFileName", (Object)this.testFile("xsltout.xml").toString());
        builder.process((Exchange)exchange);
        XsltBuilderTest.assertIsInstanceOf(File.class, exchange.getMessage().getBody());
        XsltBuilderTest.assertFileExists(this.testFile("xsltout.xml"));
        String body = (String)exchange.getMessage().getBody(String.class);
        Assertions.assertTrue((boolean)body.endsWith("<goodbye>world!</goodbye>"));
        List onCompletions = exchange.getExchangeExtension().handoverCompletions();
        UnitOfWorkHelper.doneSynchronizations((Exchange)exchange, (List)onCompletions);
        XsltBuilderTest.assertFileNotExists(this.testFile("xsltout.xml"));
    }

    @Test
    public void testXsltResultHandler() throws Exception {
        URL styleSheet = this.getClass().getResource("example.xsl");
        XsltBuilder builder = XsltBuilder.xslt((URL)styleSheet);
        Assertions.assertNotNull((Object)builder.getResultHandlerFactory());
        builder.outputBytes();
        XsltBuilderTest.assertIsInstanceOf(StreamResultHandlerFactory.class, builder.getResultHandlerFactory());
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"<hello>world!</hello>");
        builder.process((Exchange)exchange);
        Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>", (Object)exchange.getMessage().getBody(String.class));
    }

    @Test
    public void testNullBodyDefault() throws Exception {
        URL styleSheet = this.getClass().getResource("example.xsl");
        XsltBuilder builder = XsltBuilder.xslt((URL)styleSheet);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody(null);
        Assertions.assertThrows(ExpectedBodyTypeException.class, () -> XsltBuilderTest.lambda$testNullBodyDefault$0(builder, (Exchange)exchange), (String)"Should thrown an exception");
    }

    @Test
    public void testFailNullBody() throws Exception {
        URL styleSheet = this.getClass().getResource("example.xsl");
        XsltBuilder builder = XsltBuilder.xslt((URL)styleSheet);
        builder.setFailOnNullBody(true);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody(null);
        Assertions.assertThrows(ExpectedBodyTypeException.class, () -> XsltBuilderTest.lambda$testFailNullBody$1(builder, (Exchange)exchange), (String)"Should thrown an exception");
    }

    @Test
    public void testNotFailNullBody() throws Exception {
        URL styleSheet = this.getClass().getResource("example.xsl");
        XsltBuilder builder = XsltBuilder.xslt((URL)styleSheet);
        builder.setFailOnNullBody(false);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody(null);
        builder.process((Exchange)exchange);
        Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye/>", (Object)exchange.getMessage().getBody(String.class));
    }

    private static /* synthetic */ void lambda$testFailNullBody$1(XsltBuilder builder, Exchange exchange) throws Throwable {
        builder.process(exchange);
    }

    private static /* synthetic */ void lambda$testNullBodyDefault$0(XsltBuilder builder, Exchange exchange) throws Throwable {
        builder.process(exchange);
    }
}

