/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.language.xpath.DefaultNamespaceContext;
import org.apache.camel.language.xpath.XPathBuilder;
import org.apache.camel.spi.NamespaceAware;
import org.apache.camel.support.builder.Namespaces;
import org.apache.camel.support.builder.xml.NamespacesHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XPathWithNamespacesFromDomTest
extends ContextTestSupport {
    @Test
    public void testXPathUsingDomForNamespaces() {
        Document document = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<x:foo xmlns:x='n1' xmlns:y='n2'><bar id='a' xmlns:y='n3'/></x:foo>");
        Element element = (Element)document.getElementsByTagName("bar").item(0);
        Assertions.assertNotNull((Object)element, (String)"Could not find element for id 'a'");
        XPathBuilder builder = XPathBuilder.xpath((String)"//y:foo[@id='z']");
        Namespaces ns = NamespacesHelper.namespaces((Element)element);
        ns.configure((NamespaceAware)builder);
        builder.start();
        DefaultNamespaceContext namespaceContext = builder.getNamespaceContext();
        Assertions.assertEquals((Object)"n3", (Object)namespaceContext.getNamespaceURI("y"), (String)"y namespace");
        XPathWithNamespacesFromDomTest.assertPredicateMatches((Predicate)builder, this.createExchangeWithBody("<blah><foo xmlns='n3' id='z'/></blah>"));
        XPathWithNamespacesFromDomTest.assertPredicateDoesNotMatch((Predicate)builder, this.createExchangeWithBody("<blah><foo xmlns='n2' id='z'/></blah>"));
    }
}

