/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import java.lang.reflect.Field;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.language.xpath.XPathBuilder;
import org.apache.camel.util.StringHelper;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class XPathTransformTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testXPathTransform() {
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<root><firstname>Apache</firstname><lastname>Camel</lastname></root>");
        NodeList list = (NodeList)XPathBuilder.xpath((String)"/root/firstname", NodeList.class).evaluate((CamelContext)this.context, (Object)doc, NodeList.class);
        Assertions.assertNotNull((Object)list);
        list.item(0).setTextContent("Servicemix");
        String out = (String)this.context.getTypeConverter().convertTo(String.class, (Object)doc);
        Assertions.assertEquals((Object)"<root><firstname>Servicemix</firstname><lastname>Camel</lastname></root>", (Object)out);
    }

    @Test
    public void testXPathNamespaceLoggingEnabledJavaDSL() throws Exception {
        XPathTransformTest.assumeThat("Reflection on java.lang.Field has been disabled in JDK 12", XPathTransformTest.getJavaVersion(), Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(11)));
        Logger l = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)l.isInfoEnabled()).thenReturn((Object)true);
        String body = "<aRoot xmlns:nsa=\"http://namespacec.net\"><nsa:a xmlns:nsa=\"http://namespacea.net\">Hello|there|Camel</nsa:a><nsb:a xmlns:nsb=\"http://namespaceb.net\">Hello|there|Camel</nsb:a><nsb:a xmlns:nsb=\"http://namespaceb.net\">Hello|there|Camel</nsb:a><a xmlns=\"http://defaultNamespace.net\">Hello|there|Camel</a><a>Hello|there|Camel</a></aRoot>";
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)body);
        Field logField = XPathBuilder.class.getDeclaredField("LOG");
        logField.setAccessible(true);
        Field modifiers = Field.class.getDeclaredField("modifiers");
        modifiers.setAccessible(true);
        modifiers.setInt(logField, logField.getModifiers() & 0xFFFFFFEF);
        logField.set(null, l);
        NodeList list = (NodeList)XPathBuilder.xpath((String)"//*", NodeList.class).logNamespaces().evaluate((CamelContext)this.context, (Object)doc, NodeList.class);
        Assertions.assertNotNull((Object)list);
        ((Logger)Mockito.verify((Object)l)).info((String)MockitoHamcrest.argThat((Matcher)Matchers.containsString((String)"Namespaces discovered in message")), ArgumentMatchers.any(Object.class));
    }

    @Test
    public void testXPathNamespaceLoggingDisabledJavaDSL() throws Exception {
        XPathTransformTest.assumeThat("Reflection on java.lang.Field has been disabled in JDK 12", XPathTransformTest.getJavaVersion(), Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(11)));
        Logger l = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)l.isInfoEnabled()).thenReturn((Object)true);
        String body = "<aRoot xmlns:nsa=\"http://namespacec.net\"><nsa:a xmlns:nsa=\"http://namespacea.net\">Hello|there|Camel</nsa:a><nsb:a xmlns:nsb=\"http://namespaceb.net\">Hello|there|Camel</nsb:a><nsb:a xmlns:nsb=\"http://namespaceb.net\">Hello|there|Camel</nsb:a><a xmlns=\"http://defaultNamespace.net\">Hello|there|Camel</a><a>Hello|there|Camel</a></aRoot>";
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)body);
        Field logField = XPathBuilder.class.getDeclaredField("LOG");
        logField.setAccessible(true);
        Field modifiers = Field.class.getDeclaredField("modifiers");
        modifiers.setAccessible(true);
        modifiers.setInt(logField, logField.getModifiers() & 0xFFFFFFEF);
        logField.set(null, l);
        NodeList list = (NodeList)XPathBuilder.xpath((String)"//*", NodeList.class).evaluate((CamelContext)this.context, (Object)doc, NodeList.class);
        Assertions.assertNotNull((Object)list);
        ((Logger)Mockito.verify((Object)l, (VerificationMode)Mockito.never())).info((String)MockitoHamcrest.argThat((Matcher)Matchers.containsString((String)"Namespaces discovered in message")), ArgumentMatchers.any(Object.class));
    }

    private static int getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            version = StringHelper.before((String)version, (String)".", (String)version);
            version = StringHelper.before((String)version, (String)"-", (String)version);
        }
        return Integer.parseInt(version);
    }
}

