/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class XPathTransformRouteTest
extends ContextTestSupport {
    public Document replaceMe(Document doc) {
        NodeList list = doc.getElementsByTagName("firstname");
        list.item(0).setTextContent("Servicemix");
        return doc;
    }

    @Test
    public void testXPathTransform() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"<root><firstname>Servicemix</firstname><lastname>Camel</lastname></root>"});
        this.template.sendBody("direct:start", (Object)"<root><firstname>Apache</firstname><lastname>Camel</lastname></root>");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").bean(XPathTransformRouteTest.class, "replaceMe")).to(new String[]{"log:result", "mock:result"});
            }
        };
    }
}

