/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.language.xpath.XPathBuilder;
import org.apache.camel.support.builder.Namespaces;
import org.apache.camel.util.StringHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XPathTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testXPathExpressions() {
        this.assertExpression("/foo/bar/@xyz", "<foo><bar xyz='cheese'/></foo>", "cheese");
        this.assertExpression("$name", "<foo><bar xyz='cheese'/></foo>", "James");
        this.assertExpression("foo/bar", "<foo><bar>cheese</bar></foo>", "cheese");
        this.assertExpression("foo/bar/text()", "<foo><bar>cheese</bar></foo>", "cheese");
        this.assertExpression("/foo/@id", "<foo id='cheese'>hey</foo>", "cheese");
        this.assertExpression("/foo/@num", "<foo num='123'>hey</foo>", "123");
    }

    @Test
    public void testXPathPredicates() {
        this.assertPredicate("/foo/bar/@xyz", "<foo><bar xyz='cheese'/></foo>", true);
        this.assertPredicate("$name = 'James'", "<foo><bar xyz='cheese'/></foo>", true);
        this.assertPredicate("$name = 'Hiram'", "<foo><bar xyz='cheese'/></foo>", false);
        this.assertPredicate("/foo/notExist", "<foo><bar xyz='cheese'/></foo>", false);
        this.assertPredicate("/foo[@num = '123']", "<foo num='123'>hey</foo>", true);
    }

    @Test
    public void testXPathWithCustomVariable() {
        this.assertExpression((Expression)XPathBuilder.xpath((String)"$name").stringResult().variable("name", (Object)"Hiram"), "<foo/>", "Hiram");
    }

    @Test
    public void testInvalidXPath() {
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.assertPredicate("/foo/", "<foo><bar xyz='cheese'/></foo>", true), (String)"Should have thrown exception");
        XPathTest.assertIsInstanceOf(XPathExpressionException.class, e.getCause());
    }

    @Test
    public void testXPathBooleanResult() {
        Object result = XPathBuilder.xpath((String)"/foo/bar/@xyz").booleanResult().evaluate(this.createExchange("<foo><bar xyz='cheese'/></foo>"));
        Boolean bool = XPathTest.assertIsInstanceOf(Boolean.class, result);
        Assertions.assertTrue((boolean)bool);
    }

    @Test
    public void testXPathNodeResult() {
        Object result = XPathBuilder.xpath((String)"/foo/bar").nodeResult().evaluate(this.createExchange("<foo><bar xyz='cheese'/></foo>"));
        Node node = XPathTest.assertIsInstanceOf(Node.class, result);
        Assertions.assertNotNull((Object)node);
        String s = (String)this.context.getTypeConverter().convertTo(String.class, (Object)node);
        Assertions.assertEquals((Object)"<bar xyz=\"cheese\"/>", (Object)s);
    }

    @Test
    public void testXPathNodeSetResult() {
        Object result = XPathBuilder.xpath((String)"/foo").nodeSetResult().evaluate(this.createExchange("<foo>bar</foo>"));
        NodeList node = XPathTest.assertIsInstanceOf(NodeList.class, result);
        Assertions.assertNotNull((Object)node);
        String s = (String)this.context.getTypeConverter().convertTo(String.class, (Object)node);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)s);
    }

    @Test
    public void testXPathNumberResult() {
        Object result = XPathBuilder.xpath((String)"/foo/bar/@xyz").numberResult().evaluate(this.createExchange("<foo><bar xyz='123'/></foo>"));
        Double num = XPathTest.assertIsInstanceOf(Double.class, result);
        Assertions.assertEquals((Object)"123.0", (Object)num.toString());
    }

    @Test
    public void testXPathStringResult() {
        Object result = XPathBuilder.xpath((String)"/foo/bar/@xyz").stringResult().evaluate(this.createExchange("<foo><bar xyz='123'/></foo>"));
        String num = XPathTest.assertIsInstanceOf(String.class, result);
        Assertions.assertEquals((Object)"123", (Object)num);
    }

    @Test
    public void testXPathCustomResult() {
        Object result = XPathBuilder.xpath((String)"/foo/bar/@xyz").resultType(Integer.class).evaluate(this.createExchange("<foo><bar xyz='123'/></foo>"));
        Integer num = XPathTest.assertIsInstanceOf(Integer.class, result);
        Assertions.assertEquals((int)123, (int)num);
    }

    @Test
    public void testXPathBuilder() {
        XPathBuilder builder = XPathBuilder.xpath((String)"/foo/bar");
        Assertions.assertEquals((Object)"/foo/bar", (Object)builder.getText());
        Assertions.assertEquals((Object)XPathConstants.NODESET, (Object)builder.getResultQName());
        Assertions.assertNull((Object)builder.getResultType());
    }

    @Test
    public void testXPathWithDocument() {
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo>bar</foo>");
        Object result = XPathBuilder.xpath((String)"/foo").evaluate(this.createExchange(doc));
        Assertions.assertNotNull((Object)result);
        String s = (String)this.context.getTypeConverter().convertTo(String.class, result);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)s);
    }

    @Test
    public void testXPathWithDocumentTypeDOMSource() {
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo>bar</foo>");
        XPathBuilder builder = XPathBuilder.xpath((String)"/foo");
        builder.setDocumentType(DOMSource.class);
        Object result = builder.evaluate(this.createExchange(doc));
        Assertions.assertNotNull((Object)result);
        String s = (String)this.context.getTypeConverter().convertTo(String.class, result);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)s);
    }

    @Test
    public void testXPathWithDocumentTypeInputSource() {
        InputStream is = (InputStream)this.context.getTypeConverter().convertTo(InputStream.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo>bar</foo>");
        InputSource doc = new InputSource(is);
        XPathBuilder builder = XPathBuilder.xpath((String)"/foo");
        builder.setDocumentType(InputSource.class);
        Object result = builder.evaluate(this.createExchange(doc));
        Assertions.assertNotNull((Object)result);
        String s = (String)this.context.getTypeConverter().convertTo(String.class, result);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)s);
    }

    @Test
    public void testXPathWithDocumentTypeInputSourceFluentBuilder() {
        InputStream is = (InputStream)this.context.getTypeConverter().convertTo(InputStream.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo>bar</foo>");
        InputSource doc = new InputSource(is);
        XPathBuilder builder = XPathBuilder.xpath((String)"/foo").documentType(InputSource.class);
        Object result = builder.evaluate(this.createExchange(doc));
        Assertions.assertNotNull((Object)result);
        String s = (String)this.context.getTypeConverter().convertTo(String.class, result);
        Assertions.assertEquals((Object)"<foo>bar</foo>", (Object)s);
    }

    @Test
    public void testXPathWithDocumentTypeInputSourceNoResultQName() {
        InputStream is = (InputStream)this.context.getTypeConverter().convertTo(InputStream.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo>bar</foo>");
        InputSource doc = new InputSource(is);
        XPathBuilder builder = XPathBuilder.xpath((String)"/foo");
        builder.setDocumentType(InputSource.class);
        builder.setResultQName(null);
        Object result = builder.evaluate(this.createExchange(doc));
        Assertions.assertNotNull((Object)result);
        String s = (String)this.context.getTypeConverter().convertTo(String.class, result);
        Assertions.assertEquals((Object)"bar", (Object)s);
    }

    @Test
    public void testXPathWithDocumentTypeDOMSourceNoResultQName() {
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo>bar</foo>");
        XPathBuilder builder = XPathBuilder.xpath((String)"/foo");
        builder.setDocumentType(DOMSource.class);
        builder.setResultQName(null);
        Object result = builder.evaluate(this.createExchange(doc));
        Assertions.assertNotNull((Object)result);
        String s = (String)this.context.getTypeConverter().convertTo(String.class, result);
        Assertions.assertEquals((Object)"bar", (Object)s);
    }

    @Test
    public void testXPathWithStringTypeDOMSourceNoResultQName() {
        XPathBuilder builder = XPathBuilder.xpath((String)"/foo");
        builder.setResultQName(null);
        Object result = builder.evaluate(this.createExchange("<foo>bar</foo>"));
        Assertions.assertNotNull((Object)result);
        String s = (String)this.context.getTypeConverter().convertTo(String.class, result);
        Assertions.assertEquals((Object)"bar", (Object)s);
    }

    @Test
    public void testXPathWithNamespaceBooleanResult() {
        XPathBuilder builder = XPathBuilder.xpath((String)"/c:person[@name='James']").namespace("c", "http://acme.com/cheese").booleanResult();
        Object result = builder.evaluate(this.createExchange("<person xmlns=\"http://acme.com/cheese\" name='James' city='London'/>"));
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)result);
    }

    @Test
    public void testXPathWithNamespaceBooleanResultType() {
        XPathBuilder builder = XPathBuilder.xpath((String)"/c:person[@name='James']").namespace("c", "http://acme.com/cheese");
        builder.setResultType(Boolean.class);
        Object result = builder.evaluate(this.createExchange("<person xmlns=\"http://acme.com/cheese\" name='James' city='London'/>"));
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)result);
    }

    @Test
    public void testXPathWithNamespaceStringResult() {
        XPathBuilder builder = XPathBuilder.xpath((String)"/c:person/@name").namespace("c", "http://acme.com/cheese").stringResult();
        Object result = builder.evaluate(this.createExchange("<person xmlns=\"http://acme.com/cheese\" name='James' city='London'/>"));
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)"James", (Object)result);
    }

    @Test
    public void testXPathWithNamespacesBooleanResult() {
        Namespaces ns = new Namespaces("c", "http://acme.com/cheese");
        XPathBuilder builder = XPathBuilder.xpath((String)"/c:person[@name='James']").namespaces(ns).booleanResult();
        Object result = builder.evaluate(this.createExchange("<person xmlns=\"http://acme.com/cheese\" name='James' city='London'/>"));
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)result);
    }

    @Test
    public void testXPathWithNamespacesStringResult() {
        Namespaces ns = new Namespaces("c", "http://acme.com/cheese");
        XPathBuilder builder = XPathBuilder.xpath((String)"/c:person/@name").namespaces(ns).stringResult();
        Object result = builder.evaluate(this.createExchange("<person xmlns=\"http://acme.com/cheese\" name='James' city='London'/>"));
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)"James", (Object)result);
    }

    @Test
    public void testXPathWithNamespacesNodeResult() {
        Namespaces ns = new Namespaces("c", "http://acme.com/cheese");
        XPathBuilder builder = XPathBuilder.xpath((String)"/c:person/@name").namespaces(ns);
        builder.setResultType(Node.class);
        Object result = builder.evaluate(this.createExchange("<person xmlns=\"http://acme.com/cheese\" name='James' city='London'/>"));
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.toString().contains("James"));
    }

    public static String func(String message) {
        return "modified" + message;
    }

    protected Object assertExpression(String xpath, String xml, String expected) {
        XPathBuilder expression = XPathBuilder.xpath((String)xpath).stringResult();
        return this.assertExpression((Expression)expression, xml, expected);
    }

    protected Object assertExpression(Expression expression, String xml, String expected) {
        return XPathTest.assertExpression(expression, this.createExchange(xml), expected);
    }

    protected void assertPredicate(String xpath, String xml, boolean expected) {
        XPathBuilder predicate = XPathBuilder.xpath((String)xpath);
        XPathTest.assertPredicate((Predicate)predicate, this.createExchange(xml), expected);
    }

    protected Exchange createExchange(Object xml) {
        Exchange exchange = this.createExchangeWithBody((CamelContext)this.context, xml);
        exchange.getIn().setHeader("name", (Object)"James");
        return exchange;
    }

    @Test
    public void testXPathNotUsingExchangeMatches() {
        Assertions.assertTrue((boolean)XPathBuilder.xpath((String)"/foo/bar/@xyz").matches((CamelContext)this.context, (Object)"<foo><bar xyz='cheese'/></foo>"));
        Assertions.assertFalse((boolean)XPathBuilder.xpath((String)"/foo/bar/@xyz").matches((CamelContext)this.context, (Object)"<foo>Hello World</foo>"));
    }

    @Test
    public void testXPathNotUsingExchangeEvaluate() {
        String name = (String)XPathBuilder.xpath((String)"foo/bar").evaluate((CamelContext)this.context, (Object)"<foo><bar>cheese</bar></foo>", String.class);
        Assertions.assertEquals((Object)"<bar>cheese</bar>", (Object)name);
        name = (String)XPathBuilder.xpath((String)"foo/bar/text()").evaluate((CamelContext)this.context, (Object)"<foo><bar>cheese</bar></foo>", String.class);
        Assertions.assertEquals((Object)"cheese", (Object)name);
        Integer number = (Integer)XPathBuilder.xpath((String)"foo/bar").evaluate((CamelContext)this.context, (Object)"<foo><bar>123</bar></foo>", Integer.class);
        Assertions.assertEquals((int)123, (int)number);
        Boolean bool = (Boolean)XPathBuilder.xpath((String)"foo/bar").evaluate((CamelContext)this.context, (Object)"<foo><bar>true</bar></foo>", Boolean.class);
        Assertions.assertTrue((boolean)bool);
    }

    @Test
    public void testNotUsingExchangeResultType() {
        String xml = "<xml><a>1</a><a>2</a></xml>";
        XPathBuilder xpb = new XPathBuilder("/xml/a/text()");
        Assertions.assertEquals((Object)"12", (Object)xpb.evaluate((CamelContext)this.context, (Object)xml, String.class));
        xpb.setResultType(String.class);
        Assertions.assertEquals((Object)"1", (Object)xpb.evaluate((CamelContext)this.context, (Object)xml));
    }

    @Test
    public void testXPathSplit() {
        Object node = XPathBuilder.xpath((String)"foo/bar").nodeResult().evaluate(this.createExchange("<foo><bar>cheese</bar><bar>cake</bar><bar>beer</bar></foo>"));
        Assertions.assertNotNull((Object)node);
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, node);
        Assertions.assertNotNull((Object)doc);
    }

    @Test
    public void testXPathSplitConcurrent() throws Exception {
        int size = 100;
        final Object node = XPathBuilder.xpath((String)"foo/bar").nodeResult().evaluate(this.createExchange("<foo><bar>cheese</bar><bar>cake</bar><bar>beer</bar></foo>"));
        Assertions.assertNotNull((Object)node);
        final ArrayList result = new ArrayList();
        ExecutorService executor = Executors.newFixedThreadPool(size);
        final CountDownLatch latch = new CountDownLatch(size);
        for (int i = 0; i < size; ++i) {
            executor.submit(new Callable<Document>(){

                @Override
                public Document call() {
                    try {
                        Document doc = (Document)XPathTest.this.context.getTypeConverter().convertTo(Document.class, node);
                        result.add(doc);
                        Document document = doc;
                        return document;
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        Assertions.assertTrue((boolean)latch.await(20L, TimeUnit.SECONDS));
        Iterator it = result.iterator();
        int count = 0;
        while (it.hasNext()) {
            ++count;
            Document doc = (Document)it.next();
            Assertions.assertNotNull((Object)doc);
        }
        Assertions.assertEquals((int)size, (int)count);
        executor.shutdownNow();
    }

    @Test
    public void testXPathNodeListTest() {
        String xml = "<foo><person id=\"1\">Claus<country>SE</country></person><person id=\"2\">Jonathan<country>CA</country></person></foo>";
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)xml);
        Object result = XPathBuilder.xpath((String)"/foo/person").nodeSetResult().evaluate(this.createExchange(doc));
        Assertions.assertNotNull((Object)result);
        String s = (String)this.context.getTypeConverter().convertTo(String.class, result);
        Assertions.assertEquals((Object)StringHelper.between((String)xml, (String)"<foo>", (String)"</foo>"), (Object)s);
    }

    @Test
    public void testXPathNodeListSimpleTest() {
        String xml = "<foo><person>Claus</person></foo>";
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)xml);
        Object result = XPathBuilder.xpath((String)"/foo/person").nodeSetResult().evaluate(this.createExchange(doc));
        Assertions.assertNotNull((Object)result);
        String s = (String)this.context.getTypeConverter().convertTo(String.class, result);
        Assertions.assertEquals((Object)"<person>Claus</person>", (Object)s);
    }

    @Test
    public void testXPathNodeListSimpleTestText() {
        String xml = "<foo><person>Claus</person></foo>";
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)xml);
        Object result = XPathBuilder.xpath((String)"/foo/person/text()").nodeSetResult().evaluate(this.createExchange(doc));
        Assertions.assertNotNull((Object)result);
        String s = (String)this.context.getTypeConverter().convertTo(String.class, result);
        Assertions.assertEquals((Object)"Claus", (Object)s);
    }

    @Test
    public void testXPathString() {
        XPathBuilder builder = XPathBuilder.xpath((String)"foo/bar");
        String name = (String)builder.evaluate((CamelContext)this.context, (Object)"<foo><bar id=\"1\">cheese</bar></foo>", String.class);
        Assertions.assertEquals((Object)"<bar id=\"1\">cheese</bar>", (Object)name);
        name = builder.evaluate((CamelContext)this.context, (Object)"<foo><bar id=\"1\">cheese</bar></foo>");
        Assertions.assertEquals((Object)"cheese", (Object)name);
    }
}

