/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.support.builder.Namespaces;
import org.junit.jupiter.api.Test;

public class XPathNamespaceTest
extends ContextTestSupport {
    @Test
    public void testXPathWithNamespace() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:55");
        mock.expectedBodiesReceived(new Object[]{"<number xmlns=\"http://acme.com/cheese\">55</number>"});
        this.template.sendBody("direct:in", (Object)"<number xmlns=\"http://acme.com/cheese\">55</number>");
        mock.assertIsSatisfied();
    }

    @Test
    public void testXPathWithNamespaceOther() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:other");
        mock.expectedBodiesReceived(new Object[]{"<number xmlns=\"http://acme.com/cheese\">99</number>"});
        this.template.sendBody("direct:in", (Object)"<number xmlns=\"http://acme.com/cheese\">99</number>");
        mock.assertIsSatisfied();
    }

    @Test
    public void testXPathWithNamespaceDifferentNamespace() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:other");
        mock.expectedBodiesReceived(new Object[]{"<number xmlns=\"http://acme.com/cake\">55</number>"});
        this.template.sendBody("direct:in", (Object)"<number xmlns=\"http://acme.com/cake\">55</number>");
        mock.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                Namespaces ns = new Namespaces("c", "http://acme.com/cheese");
                ((ChoiceDefinition)((ChoiceDefinition)this.from("direct:in").choice().when((Predicate)this.xpath("/c:number = 55", Integer.class, ns)).to("mock:55")).otherwise().to("mock:other")).end();
            }
        };
    }
}

