/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.language.xpath.XPathBuilder;
import org.junit.jupiter.api.Test;

public class XPathMockTest
extends ContextTestSupport {
    @Test
    public void testXPathMock() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        ((MockValueBuilder)mock.message(0).body()).matches((Expression)XPathBuilder.xpath((String)"/foo/text() = 'Hello World'").booleanResult());
        this.template.sendBody("direct:start", (Object)"<foo>Hello World</foo>");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testXPathMock2() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.message(0).predicate().xpath("/foo/text() = 'Hello World'");
        this.template.sendBody("direct:start", (Object)"<foo>Hello World</foo>");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testXPathMock2Fail() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.message(0).predicate().xpath("/foo/text() = 'Bye World'");
        this.template.sendBody("direct:start", (Object)"<foo>Hello World</foo>");
        mock.assertIsNotSatisfied();
    }

    @Test
    public void testXPathMock3() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.message(0).predicate().xpath("/foo/text() = 'Hello World'");
        this.template.sendBody("direct:start", (Object)"<foo>Hello World</foo>");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testXPathMockMatches() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessagesMatches(new Predicate[]{XPathBuilder.xpath((String)"/foo/text() = 'Hello World'")});
        this.template.sendBody("direct:start", (Object)"<foo>Hello World</foo>");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testXPathMockMatchesTwo() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessagesMatches(new Predicate[]{XPathBuilder.xpath((String)"/foo/text() = 'Hello World'"), XPathBuilder.xpath((String)"/foo/text() = 'Bye World'")});
        this.template.sendBody("direct:start", (Object)"<foo>Hello World</foo>");
        this.template.sendBody("direct:start", (Object)"<foo>Bye World</foo>");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testNonXPathMockMatches() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessagesMatches(new Predicate[]{PredicateBuilder.not((Predicate)XPathMockTest.body().contains((Object)"Bye")), XPathMockTest.body().contains((Object)"World")});
        this.template.sendBody("direct:start", (Object)"<foo>Hello World</foo>");
        this.template.sendBody("direct:start", (Object)"<foo>Bye World</foo>");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

