/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;
import org.junit.jupiter.api.Test;

public class XPathHeaderTest
extends ContextTestSupport {
    @Test
    public void testChoiceWithHeaderSelectCamel() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:camel");
        mock.expectedBodiesReceived(new Object[]{"<name>King</name>"});
        mock.expectedHeaderReceived("type", (Object)"Camel");
        this.template.sendBodyAndHeader("direct:in", (Object)"<name>King</name>", "type", (Object)"Camel");
        mock.assertIsSatisfied();
    }

    @Test
    public void testChoiceWithNoHeaderSelectDonkey() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:donkey");
        mock.expectedBodiesReceived(new Object[]{"<name>Kong</name>"});
        this.template.sendBody("direct:in", (Object)"<name>Kong</name>");
        mock.assertIsSatisfied();
    }

    @Test
    public void testChoiceWithNoHeaderSelectOther() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:other");
        mock.expectedBodiesReceived(new Object[]{"<name>Other</name>"});
        this.template.sendBody("direct:in", (Object)"<name>Other</name>");
        mock.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:in").choice().when().xpath("$type = 'Camel'")).to("mock:camel")).when().xpath("//name = 'Kong'")).to("mock:donkey")).otherwise().to("mock:other")).end();
            }
        };
    }
}

