/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.language.XPathExpression;
import org.junit.jupiter.api.Test;

public class XPathHeaderNameTest
extends ContextTestSupport {
    @Test
    public void testChoiceWithHeaderNamePremium() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:premium");
        mock.expectedBodiesReceived(new Object[]{"<response>OK</response>"});
        mock.expectedHeaderReceived("invoiceDetails", (Object)"<invoice orderType='premium'><person><name>Alan</name></person></invoice>");
        this.template.sendBodyAndHeader("direct:in", (Object)"<response>OK</response>", "invoiceDetails", (Object)"<invoice orderType='premium'><person><name>Alan</name></person></invoice>");
        mock.assertIsSatisfied();
    }

    @Test
    public void testChoiceWithHeaderNameStandard() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:standard");
        mock.expectedBodiesReceived(new Object[]{"<response>OK</response>"});
        mock.expectedHeaderReceived("invoiceDetails", (Object)"<invoice orderType='standard'><person><name>Alan</name></person></invoice>");
        this.template.sendBodyAndHeader("direct:in", (Object)"<response>OK</response>", "invoiceDetails", (Object)"<invoice orderType='standard'><person><name>Alan</name></person></invoice>");
        mock.assertIsSatisfied();
    }

    @Test
    public void testChoiceWithHeaderNameUnknown() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:unknown");
        mock.expectedBodiesReceived(new Object[]{"<response>OK</response>"});
        mock.expectedHeaderReceived("invoiceDetails", (Object)"<invoice />");
        this.template.sendBodyAndHeader("direct:in", (Object)"<response>OK</response>", "invoiceDetails", (Object)"<invoice />");
        mock.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                XPathExpression premium = ((XPathExpression.Builder)((XPathExpression.Builder)this.expression().xpath().expression("/invoice/@orderType = 'premium'")).source("header:invoiceDetails")).end();
                XPathExpression standard = ((XPathExpression.Builder)((XPathExpression.Builder)this.expression().xpath().expression("/invoice/@orderType = 'standard'")).source("header:invoiceDetails")).end();
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:in").choice().when((Predicate)premium).to("mock:premium")).when((Predicate)standard).to("mock:standard")).otherwise().to("mock:unknown")).end();
            }
        };
    }
}

