/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;
import org.junit.jupiter.api.Test;

public class XPathFunctionsONielProblemTest
extends ContextTestSupport {
    @Test
    public void testChoiceWithHeaderAndPropertiesSelectCamel() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:camel");
        mock.expectedBodiesReceived(new Object[]{"<name>King</name>"});
        mock.expectedHeaderReceived("type", (Object)"Camel");
        this.template.sendBodyAndHeader("direct:in", (Object)"<name>King</name>", "type", (Object)"Camel");
        mock.assertIsSatisfied();
    }

    @Test
    public void testChoiceWithNoHeaderAndPropertiesSelectDonkey() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:donkey");
        mock.expectedBodiesReceived(new Object[]{"<name>Kong</name>"});
        this.template.sendBody("direct:in", (Object)"<name>Kong</name>");
        mock.assertIsSatisfied();
    }

    @Test
    public void testChoiceWithNoHeaderAndPropertiesSelectOther() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:other");
        mock.expectedBodiesReceived(new Object[]{"<name>Other</name>"});
        this.template.sendBody("direct:in", (Object)"<name>Other</name>");
        mock.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                XPathFunctionsONielProblemTest.this.context.getPropertiesComponent().setLocation("classpath:org/apache/camel/builder/xml/myprop.properties");
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:in").choice().when().xpath("$type = function:properties('foo')")).to("mock:camel")).when().xpath("//name = function:simple('{{bar}}')")).to("mock:donkey")).otherwise().to("mock:other")).end();
            }
        };
    }
}

