/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import java.io.FileNotFoundException;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConversionException;
import org.apache.camel.language.xpath.XPathBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.xml.sax.SAXParseException;

@ResourceLock(value="java.lang.System.properties")
public class XPathFeatureTest
extends ContextTestSupport {
    public static final String DOM_BUILDER_FACTORY_FEATURE = "org.apache.camel.xmlconverter.documentBuilderFactory.feature";
    public static final String XML_DATA = " <!DOCTYPE foo [  <!ELEMENT foo ANY > <!ENTITY xxe SYSTEM \"file:///bin/test.sh\" >]> <test> &xxe; </test>";
    public static final String XML_DATA_INVALID = " <!DOCTYPE foo [  <!ELEMENT foo ANY > <!ENTITY xxe SYSTEM \"file:///bin/test.sh\" >]> <test> &xxe; </test><notwellformed>";

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testXPathDocTypeDisallowed() {
        try {
            XPathBuilder.xpath((String)"/").stringResult().evaluate(this.createExchange(XML_DATA));
            Assertions.fail();
        }
        catch (Exception e) {
            XPathFeatureTest.assertIsInstanceOf(SAXParseException.class, e.getCause());
        }
    }

    @Test
    public void testXPath() {
        System.setProperty("org.apache.camel.xmlconverter.documentBuilderFactory.feature:http://xml.org/sax/features/external-general-entities", "true");
        System.setProperty("org.apache.camel.xmlconverter.documentBuilderFactory.feature:http://apache.org/xml/features/disallow-doctype-decl", "false");
        try {
            XPathBuilder.xpath((String)"/").stringResult().evaluate(this.createExchange(XML_DATA));
            Assertions.fail((String)"Expect an Exception here");
        }
        catch (TypeConversionException ex) {
            boolean b = ex.getCause() instanceof FileNotFoundException;
            Assertions.assertTrue((boolean)b, (String)("Get a wrong exception cause: " + String.valueOf(ex.getCause().getClass()) + " instead of " + String.valueOf(FileNotFoundException.class)));
        }
        finally {
            System.clearProperty("org.apache.camel.xmlconverter.documentBuilderFactory.feature:http://xml.org/sax/features/external-general-entities");
            System.clearProperty("org.apache.camel.xmlconverter.documentBuilderFactory.feature:http://apache.org/xml/features/disallow-doctype-decl");
        }
    }

    @Test
    public void testXPathNoTypeConverter() {
        try {
            XPathBuilder.xpath((String)"/").documentType(Exchange.class).stringResult().evaluate(this.createExchange(XML_DATA));
            Assertions.fail((String)"Expect an Exception here");
        }
        catch (RuntimeCamelException ex) {
            boolean b = ex.getCause() instanceof NoTypeConversionAvailableException;
            Assertions.assertTrue((boolean)b, (String)("Get a wrong exception cause: " + String.valueOf(ex.getCause().getClass()) + " instead of " + String.valueOf(NoTypeConversionAvailableException.class)));
        }
    }

    @Test
    public void testXPathResultOnInvalidData() {
        try {
            XPathBuilder.xpath((String)"/").stringResult().evaluate(this.createExchange(XML_DATA_INVALID));
            Assertions.fail((String)"Expect an Exception here");
        }
        catch (TypeConversionException ex) {
            boolean b = ex.getCause() instanceof SAXParseException;
            Assertions.assertTrue((boolean)b, (String)("Get a wrong exception cause: " + String.valueOf(ex.getCause().getClass()) + " instead of " + String.valueOf(SAXParseException.class)));
        }
    }

    protected Exchange createExchange(Object xml) {
        Exchange exchange = this.createExchangeWithBody((CamelContext)this.context, xml);
        return exchange;
    }
}

