/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.support.builder.Namespaces;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExtractXPathWithNamespaceTest
extends ContextTestSupport {
    @Test
    public void testXPathWithNamespace() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"<number xmlns=\"http://acme.com/cheese\">55</number>"});
        mock.expectedHeaderReceived("foo", (Object)55);
        this.template.sendBody("direct:in", (Object)"<number xmlns=\"http://acme.com/cheese\">55</number>");
        mock.assertIsSatisfied();
    }

    @Test
    public void testXPathWithNamespaceOther() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"<number xmlns=\"http://acme.com/cheese\">99</number>"});
        mock.expectedHeaderReceived("foo", (Object)99);
        this.template.sendBody("direct:in", (Object)"<number xmlns=\"http://acme.com/cheese\">99</number>");
        mock.assertIsSatisfied();
    }

    @Test
    public void testXPathWithNamespaceDifferentNamespace() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"<number xmlns=\"http://acme.com/cake\">55</number>"});
        this.template.sendBody("direct:in", (Object)"<number xmlns=\"http://acme.com/cake\">55</number>");
        mock.assertIsSatisfied();
        Assertions.assertNull((Object)((Exchange)mock.getExchanges().get(0)).getIn().getHeader("foo"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                Namespaces ns = new Namespaces("c", "http://acme.com/cheese");
                ((ProcessorDefinition)this.from("direct:in").setHeader("foo").xpath("/c:number", Integer.class, ns)).to("mock:result");
            }
        };
    }
}

