/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.language.xpath.DefaultNamespaceContext;
import org.apache.camel.language.xpath.XPathBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultNamespaceContextTest
extends ContextTestSupport {
    @Test
    public void testDefaultNamespaceContextEmpty() {
        XPathBuilder builder = XPathBuilder.xpath((String)"/foo");
        builder.start();
        DefaultNamespaceContext context = builder.getNamespaceContext();
        Assertions.assertNotNull((Object)context);
        String uri = context.getNamespaceURI("foo");
        Assertions.assertNull((Object)uri);
        String prefix = context.getPrefix("foo");
        Assertions.assertNull((Object)prefix);
        Iterator it = context.getPrefixes("foo");
        Assertions.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testDefaultNamespaceContextPre() {
        XPathBuilder builder = XPathBuilder.xpath((String)"/foo").namespace("pre", "http://acme/cheese");
        builder.start();
        DefaultNamespaceContext context = builder.getNamespaceContext();
        Assertions.assertNotNull((Object)context);
        String uri = context.getNamespaceURI("pre");
        Assertions.assertEquals((Object)"http://acme/cheese", (Object)uri);
        String prefix = context.getPrefix("http://acme/cheese");
        Assertions.assertEquals((Object)"pre", (Object)prefix);
        Iterator it = context.getPrefixes("http://acme/cheese");
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"pre", it.next());
    }

    @Test
    public void testDefaultNamespaceContextDualNamespaces() {
        XPathBuilder builder = XPathBuilder.xpath((String)"/foo").namespace("pre", "http://acme/cheese").namespace("bar", "http://acme/bar");
        builder.start();
        DefaultNamespaceContext context = builder.getNamespaceContext();
        Assertions.assertNotNull((Object)context);
        String uri = context.getNamespaceURI("pre");
        Assertions.assertEquals((Object)"http://acme/cheese", (Object)uri);
        String uri2 = context.getNamespaceURI("bar");
        Assertions.assertEquals((Object)"http://acme/bar", (Object)uri2);
        String prefix = context.getPrefix("http://acme/cheese");
        Assertions.assertEquals((Object)"pre", (Object)prefix);
        String prefix2 = context.getPrefix("http://acme/bar");
        Assertions.assertEquals((Object)"bar", (Object)prefix2);
        Iterator it = context.getPrefixes("http://acme/cheese");
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"pre", it.next());
        Iterator it2 = context.getPrefixes("http://acme/bar");
        Assertions.assertTrue((boolean)it2.hasNext());
        Assertions.assertEquals((Object)"bar", it2.next());
    }

    @Test
    public void testDefaultNamespaceContextParent() {
        XPathBuilder builder = XPathBuilder.xpath((String)"/foo");
        builder.start();
        DefaultNamespaceContext context = builder.getNamespaceContext();
        Assertions.assertNotNull((Object)context);
        String uri = context.getNamespaceURI("in");
        Assertions.assertEquals((Object)"http://camel.apache.org/xml/in/", (Object)uri);
        String prefix = context.getPrefix("http://camel.apache.org/xml/in/");
        Assertions.assertEquals((Object)"in", (Object)prefix);
        Iterator it = context.getPrefixes("http://camel.apache.org/xml/in/");
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"in", it.next());
        String uri2 = context.getNamespaceURI("out");
        Assertions.assertEquals((Object)"http://camel.apache.org/xml/out/", (Object)uri2);
        String uri3 = context.getNamespaceURI("env");
        Assertions.assertEquals((Object)"http://camel.apache.org/xml/variables/environment-variables", (Object)uri3);
        String uri4 = context.getNamespaceURI("system");
        Assertions.assertEquals((Object)"http://camel.apache.org/xml/variables/system-properties", (Object)uri4);
    }

    @Test
    public void testDefaultNamespaceContextCtr() {
        DefaultNamespaceContext context = new DefaultNamespaceContext();
        String uri = context.getNamespaceURI("in");
        Assertions.assertNull((Object)uri);
    }

    @Test
    public void testDefaultNamespaceContextAnotherCtr() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "http://acme/cheese");
        DefaultNamespaceContext context = new DefaultNamespaceContext(null, map);
        String uri = context.getNamespaceURI("in");
        Assertions.assertNull((Object)uri);
        String uri2 = context.getNamespaceURI("foo");
        Assertions.assertEquals((Object)"http://acme/cheese", (Object)uri2);
    }
}

