/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.lang.reflect.Field;
import org.apache.camel.Message;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.processor.SendProcessor;
import org.apache.camel.processor.transformer.ProcessorTransformer;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Transformer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TransformerBuilderTest
extends TestSupport {
    @Test
    public void testEndpointTransformer() throws Exception {
        DefaultCamelContext ctx = new DefaultCamelContext();
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.transformer().fromType("json:foo").toType("xml:bar").withUri("direct:transformer");
                this.from("direct:transformer").log("test");
            }
        };
        ctx.addRoutes((RoutesBuilder)builder);
        ctx.start();
        Transformer transformer = ctx.resolveTransformer(new DataType("json:foo"), new DataType("xml:bar"));
        Assertions.assertNotNull((Object)transformer);
        Assertions.assertEquals(ProcessorTransformer.class, transformer.getClass());
        ProcessorTransformer pt = (ProcessorTransformer)transformer;
        Field f = ProcessorTransformer.class.getDeclaredField("processor");
        f.setAccessible(true);
        Object processor = f.get(pt);
        Assertions.assertEquals(SendProcessor.class, processor.getClass());
        SendProcessor sp = (SendProcessor)processor;
        Assertions.assertEquals((Object)"direct://transformer", (Object)sp.getEndpoint().getEndpointUri());
    }

    @Test
    public void testCustomTransformer() throws Exception {
        DefaultCamelContext ctx = new DefaultCamelContext();
        RouteBuilder builder = new RouteBuilder(){

            public void configure() {
                this.transformer().name("other").withJava(MyTransformer.class);
                this.from("direct:input").log("test");
            }
        };
        ctx.addRoutes((RoutesBuilder)builder);
        ctx.start();
        Transformer transformer = ctx.resolveTransformer("other");
        Assertions.assertNotNull((Object)transformer);
        Assertions.assertEquals(MyTransformer.class, transformer.getClass());
    }

    public static class MyTransformer
    extends Transformer {
        public void transform(Message message, DataType from, DataType to) {
            message.getBody();
        }
    }
}

