/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.ThreadPoolBuilder;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.concurrent.ThreadPoolRejectedPolicy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ThreadPoolBuilderTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        ExecutorService someone = Executors.newCachedThreadPool();
        jndi.bind("someonesPool", (Object)someone);
        return jndi;
    }

    @Test
    public void testThreadPoolBuilderDefault() throws Exception {
        ThreadPoolBuilder builder = new ThreadPoolBuilder((CamelContext)this.context);
        ExecutorService executor = builder.build((Object)this, "myPool");
        Assertions.assertNotNull((Object)executor);
        Assertions.assertFalse((boolean)executor.isShutdown());
        this.context.stop();
        Assertions.assertTrue((boolean)executor.isShutdown());
    }

    @Test
    public void testThreadPoolBuilderMaxQueueSize() throws Exception {
        ThreadPoolBuilder builder = new ThreadPoolBuilder((CamelContext)this.context);
        ExecutorService executor = builder.maxQueueSize(2000).build((Object)this, "myPool");
        Assertions.assertNotNull((Object)executor);
        Assertions.assertFalse((boolean)executor.isShutdown());
        this.context.stop();
        Assertions.assertTrue((boolean)executor.isShutdown());
    }

    @Test
    public void testThreadPoolBuilderMax() throws Exception {
        ThreadPoolBuilder builder = new ThreadPoolBuilder((CamelContext)this.context);
        ExecutorService executor = builder.maxPoolSize(100).build((Object)this, "myPool");
        Assertions.assertNotNull((Object)executor);
        Assertions.assertFalse((boolean)executor.isShutdown());
        this.context.stop();
        Assertions.assertTrue((boolean)executor.isShutdown());
    }

    @Test
    public void testThreadPoolBuilderCoreAndMax() throws Exception {
        ThreadPoolBuilder builder = new ThreadPoolBuilder((CamelContext)this.context);
        ExecutorService executor = builder.poolSize(50).maxPoolSize(100).build((Object)this, "myPool");
        Assertions.assertNotNull((Object)executor);
        Assertions.assertFalse((boolean)executor.isShutdown());
        this.context.stop();
        Assertions.assertTrue((boolean)executor.isShutdown());
    }

    @Test
    public void testThreadPoolBuilderKeepAlive() throws Exception {
        ThreadPoolBuilder builder = new ThreadPoolBuilder((CamelContext)this.context);
        ExecutorService executor = builder.keepAliveTime(30L).build((Object)this, "myPool");
        Assertions.assertNotNull((Object)executor);
        Assertions.assertFalse((boolean)executor.isShutdown());
        this.context.stop();
        Assertions.assertTrue((boolean)executor.isShutdown());
    }

    @Test
    public void testThreadPoolBuilderKeepAliveTimeUnit() throws Exception {
        ThreadPoolBuilder builder = new ThreadPoolBuilder((CamelContext)this.context);
        ExecutorService executor = builder.keepAliveTime(20000L, TimeUnit.MILLISECONDS).build((Object)this, "myPool");
        Assertions.assertNotNull((Object)executor);
        Assertions.assertFalse((boolean)executor.isShutdown());
        this.context.stop();
        Assertions.assertTrue((boolean)executor.isShutdown());
    }

    @Test
    public void testThreadPoolBuilderAll() throws Exception {
        ThreadPoolBuilder builder = new ThreadPoolBuilder((CamelContext)this.context);
        ExecutorService executor = builder.poolSize(50).maxPoolSize(100).maxQueueSize(2000).keepAliveTime(20000L, TimeUnit.MILLISECONDS).rejectedPolicy(ThreadPoolRejectedPolicy.Abort).build((Object)this, "myPool");
        Assertions.assertNotNull((Object)executor);
        Assertions.assertFalse((boolean)executor.isShutdown());
        this.context.stop();
        Assertions.assertTrue((boolean)executor.isShutdown());
    }

    @Test
    public void testThreadPoolBuilderTwoPoolsDefault() throws Exception {
        ThreadPoolBuilder builder = new ThreadPoolBuilder((CamelContext)this.context);
        ExecutorService executor = builder.build((Object)this, "myPool");
        ExecutorService executor2 = builder.build((Object)this, "myOtherPool");
        Assertions.assertNotNull((Object)executor);
        Assertions.assertNotNull((Object)executor2);
        Assertions.assertFalse((boolean)executor.isShutdown());
        Assertions.assertFalse((boolean)executor2.isShutdown());
        this.context.stop();
        Assertions.assertTrue((boolean)executor.isShutdown());
        Assertions.assertTrue((boolean)executor2.isShutdown());
    }

    @Test
    public void testThreadPoolBuilderScheduled() throws Exception {
        ThreadPoolBuilder builder = new ThreadPoolBuilder((CamelContext)this.context);
        ScheduledExecutorService executor = builder.poolSize(5).maxQueueSize(2000).buildScheduled();
        Assertions.assertNotNull((Object)executor);
        Assertions.assertFalse((boolean)executor.isShutdown());
        this.context.stop();
        Assertions.assertTrue((boolean)executor.isShutdown());
    }

    @Test
    public void testThreadPoolBuilderScheduledName() throws Exception {
        ThreadPoolBuilder builder = new ThreadPoolBuilder((CamelContext)this.context);
        ScheduledExecutorService executor = builder.poolSize(5).maxQueueSize(2000).buildScheduled("myScheduledPool");
        Assertions.assertNotNull((Object)executor);
        Assertions.assertFalse((boolean)executor.isShutdown());
        this.context.stop();
        Assertions.assertTrue((boolean)executor.isShutdown());
    }

    @Test
    public void testThreadPoolBuilderScheduledSourceName() throws Exception {
        ThreadPoolBuilder builder = new ThreadPoolBuilder((CamelContext)this.context);
        ScheduledExecutorService executor = builder.poolSize(5).maxQueueSize(2000).buildScheduled((Object)this, "myScheduledPool");
        Assertions.assertNotNull((Object)executor);
        Assertions.assertFalse((boolean)executor.isShutdown());
        this.context.stop();
        Assertions.assertTrue((boolean)executor.isShutdown());
    }
}

