/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.List;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.engine.DefaultRoute;
import org.apache.camel.util.CollectionHelper;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteTemplateStreamCacheTest {
    @Test
    public void testRouteTemplateStreamCache() throws Exception {
        try (DefaultCamelContext context = new DefaultCamelContext();){
            context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() {
                    this.routeTemplate("myTemplate").templateParameter("foo").templateParameter("bar").templateParameter("mask").route().noStreamCaching().messageHistory().logMask("{{mask}}").from("direct:{{foo}}").to("mock:{{bar}}");
                }
            });
            context.addRouteFromTemplate("myId", "myTemplate", CollectionHelper.mapOf((Object)"foo", (Object)"start", (Object[])new Object[]{"bar", "result", "mask", "true"}));
            context.start();
            Assertions.assertThat((List)context.getRoutes()).allSatisfy(r -> Assertions.assertThat((Object)r).isInstanceOfSatisfying(DefaultRoute.class, dr -> {
                Assertions.assertThat((Boolean)dr.isStreamCaching()).isFalse();
                Assertions.assertThat((Boolean)dr.isMessageHistory()).isTrue();
                Assertions.assertThat((Boolean)dr.isLogMask()).isTrue();
            }));
        }
    }
}

