/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.Map;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.StepDefinition;
import org.apache.camel.processor.StepProcessor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteTemplateStepIdTest
extends ContextTestSupport {
    @Test
    public void testStepId() throws Exception {
        this.context.addRouteFromTemplate("one", "myTemplate", Map.of("name", "one", "greeting", "Hello"));
        this.context.addRouteFromTemplate("deux", "myTemplate", Map.of("name", "deux", "greeting", "Bonjour", "myPeriod", "5s"));
        Assertions.assertEquals((int)2, (int)this.context.getRoutes().size());
        String nodePrefix = this.context.getRoute("one").getNodePrefixId();
        StepProcessor step1 = (StepProcessor)this.context.getProcessor(nodePrefix + "one", StepProcessor.class);
        Assertions.assertNotNull((Object)step1);
        Assertions.assertEquals((Object)(nodePrefix + "one"), (Object)step1.getId());
        Assertions.assertEquals((Object)"one", (Object)step1.getRouteId());
        nodePrefix = this.context.getRoute("deux").getNodePrefixId();
        StepProcessor step2 = (StepProcessor)this.context.getProcessor(nodePrefix + "deux", StepProcessor.class);
        Assertions.assertNotNull((Object)step2);
        Assertions.assertEquals((Object)(nodePrefix + "deux"), (Object)step2.getId());
        Assertions.assertEquals((Object)"deux", (Object)step2.getRouteId());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((StepDefinition)((StepDefinition)this.routeTemplate("myTemplate").templateParameter("name").templateParameter("greeting").templateParameter("myPeriod", "3s").from("timer:{{name}}?period={{myPeriod}}").step("{{name}}").setBody((Expression)this.simple("{{greeting}} {{name}}"))).log("${body}")).end();
            }
        };
    }
}

