/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.HashMap;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteTemplateRedeliveryTest
extends ContextTestSupport {
    @Test
    public void testCreateRouteFromRouteTemplate() throws Exception {
        Assertions.assertEquals((int)1, (int)this.context.getRouteTemplateDefinitions().size());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("myCount", "3");
        parameters.put("myFac", "1");
        this.context.addRouteFromTemplate("first", "myTemplate", parameters);
        String out = (String)this.template.requestBody("direct:start", (Object)"Hello World", String.class);
        Assertions.assertEquals((Object)"3", (Object)out);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.routeTemplate("myTemplate").templateParameter("myCount").templateParameter("myFac").from("direct:start").onException(Exception.class).maximumRedeliveryDelay(1L).maximumRedeliveries("{{myCount}}").collisionAvoidanceFactor("{{myFac}}").onRedelivery(e -> e.getMessage().setBody(e.getMessage().getHeader("CamelRedeliveryCounter"))).handled(true).end().throwException((Exception)new IllegalArgumentException("Forced"));
            }
        };
    }
}

