/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.TemplatedRouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.RouteTemplateParameterDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteTemplatePrefixIdTest
extends ContextTestSupport {
    @Test
    public void testDefineRouteTemplate() {
        Assertions.assertEquals((int)1, (int)this.context.getRouteTemplateDefinitions().size());
        RouteTemplateDefinition routeTemplate = this.context.getRouteTemplateDefinition("myTemplate");
        Assertions.assertEquals((Object)"foo", (Object)((RouteTemplateParameterDefinition)routeTemplate.getTemplateParameters().get(0)).getName());
        Assertions.assertEquals((Object)"bar", (Object)((RouteTemplateParameterDefinition)routeTemplate.getTemplateParameters().get(1)).getName());
    }

    @Test
    public void testCreateRouteFromRouteTemplate() throws Exception {
        Assertions.assertEquals((int)1, (int)this.context.getRouteTemplateDefinitions().size());
        RouteTemplateDefinition routeTemplate = this.context.getRouteTemplateDefinition("myTemplate");
        Assertions.assertEquals((Object)"foo", (Object)((RouteTemplateParameterDefinition)routeTemplate.getTemplateParameters().get(0)).getName());
        Assertions.assertEquals((Object)"bar", (Object)((RouteTemplateParameterDefinition)routeTemplate.getTemplateParameters().get(1)).getName());
        this.getMockEndpoint("mock:cheese").expectedBodiesReceived(new Object[]{"Hello Cheese"});
        this.getMockEndpoint("mock:cake").expectedBodiesReceived(new Object[]{"Hello Cake"});
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("foo", "one");
        parameters.put("bar", "cheese");
        this.context.addRouteFromTemplate("first", "myTemplate", "aaa", parameters);
        parameters.put("foo", "two");
        parameters.put("bar", "cake");
        this.context.addRouteFromTemplate("second", "myTemplate", "bbb", parameters);
        Assertions.assertEquals((int)2, (int)this.context.getRouteDefinitions().size());
        Assertions.assertEquals((int)2, (int)this.context.getRoutes().size());
        Assertions.assertEquals((Object)"Started", (Object)this.context.getRouteController().getRouteStatus("first").name());
        Assertions.assertEquals((Object)"Started", (Object)this.context.getRouteController().getRouteStatus("second").name());
        Assertions.assertEquals((Object)"true", this.context.getRoute("first").getProperties().get("template"));
        Assertions.assertEquals((Object)"true", this.context.getRoute("second").getProperties().get("template"));
        this.template.sendBody("direct:one", (Object)"Hello Cheese");
        this.template.sendBody("direct:two", (Object)"Hello Cake");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)3, (int)this.context.getRoute("first").filter("aaa*").size());
        Assertions.assertEquals((int)3, (int)this.context.getRoute("second").filter("bbb*").size());
    }

    @Test
    public void testCreateRouteFromRouteTemplateFluent() throws Exception {
        Assertions.assertEquals((int)1, (int)this.context.getRouteTemplateDefinitions().size());
        RouteTemplateDefinition routeTemplate = this.context.getRouteTemplateDefinition("myTemplate");
        Assertions.assertEquals((Object)"foo", (Object)((RouteTemplateParameterDefinition)routeTemplate.getTemplateParameters().get(0)).getName());
        Assertions.assertEquals((Object)"bar", (Object)((RouteTemplateParameterDefinition)routeTemplate.getTemplateParameters().get(1)).getName());
        this.getMockEndpoint("mock:cheese").expectedBodiesReceived(new Object[]{"Hello Cheese"});
        this.getMockEndpoint("mock:cake").expectedBodiesReceived(new Object[]{"Hello Cake"});
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").routeId("first").prefixId("aaa").parameter("foo", (Object)"one").parameter("bar", (Object)"cheese").add();
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").routeId("second").prefixId("bbb").parameter("foo", (Object)"two").parameter("bar", (Object)"cake").add();
        Assertions.assertEquals((int)2, (int)this.context.getRouteDefinitions().size());
        Assertions.assertEquals((int)2, (int)this.context.getRoutes().size());
        Assertions.assertEquals((Object)"Started", (Object)this.context.getRouteController().getRouteStatus("first").name());
        Assertions.assertEquals((Object)"Started", (Object)this.context.getRouteController().getRouteStatus("second").name());
        Assertions.assertEquals((Object)"true", this.context.getRoute("first").getProperties().get("template"));
        Assertions.assertEquals((Object)"true", this.context.getRoute("second").getProperties().get("template"));
        this.template.sendBody("direct:one", (Object)"Hello Cheese");
        this.template.sendBody("direct:two", (Object)"Hello Cake");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)3, (int)this.context.getRoute("first").filter("aaa*").size());
        Assertions.assertEquals((int)3, (int)this.context.getRoute("second").filter("bbb*").size());
    }

    @Test
    public void testCreateRouteFromRouteTemplateAutoAssignedRouteId() throws Exception {
        Assertions.assertEquals((int)1, (int)this.context.getRouteTemplateDefinitions().size());
        RouteTemplateDefinition routeTemplate = this.context.getRouteTemplateDefinition("myTemplate");
        Assertions.assertEquals((Object)"foo", (Object)((RouteTemplateParameterDefinition)routeTemplate.getTemplateParameters().get(0)).getName());
        Assertions.assertEquals((Object)"bar", (Object)((RouteTemplateParameterDefinition)routeTemplate.getTemplateParameters().get(1)).getName());
        this.getMockEndpoint("mock:cheese").expectedBodiesReceived(new Object[]{"Hello Cheese"});
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("foo", "one");
        parameters.put("bar", "cheese");
        String routeId = this.context.addRouteFromTemplate(null, "myTemplate", "aaa", parameters);
        Assertions.assertNotNull((Object)routeId);
        Assertions.assertEquals((int)1, (int)this.context.getRouteDefinitions().size());
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        Assertions.assertEquals((Object)"Started", (Object)this.context.getRouteController().getRouteStatus(routeId).name());
        Assertions.assertEquals((Object)"true", this.context.getRoute(routeId).getProperties().get("template"));
        this.template.sendBody("direct:one", (Object)"Hello Cheese");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)3, (int)this.context.getRoute(routeId).filter("aaa*").size());
    }

    @Test
    public void testCreateRouteFromRouteTemplateAutoAssignedRouteIdClash() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:hello").to("mock:hello")).routeId("route1");
            }
        });
        Assertions.assertEquals((int)1, (int)this.context.getRouteDefinitions().size());
        Assertions.assertEquals((int)1, (int)this.context.getRouteTemplateDefinitions().size());
        RouteTemplateDefinition routeTemplate = this.context.getRouteTemplateDefinition("myTemplate");
        Assertions.assertEquals((Object)"foo", (Object)((RouteTemplateParameterDefinition)routeTemplate.getTemplateParameters().get(0)).getName());
        Assertions.assertEquals((Object)"bar", (Object)((RouteTemplateParameterDefinition)routeTemplate.getTemplateParameters().get(1)).getName());
        this.getMockEndpoint("mock:cheese").expectedBodiesReceived(new Object[]{"Hello Cheese"});
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("foo", "one");
        parameters.put("bar", "cheese");
        String routeId = this.context.addRouteFromTemplate(null, "myTemplate", "aaa", parameters);
        Assertions.assertNotNull((Object)routeId);
        Assertions.assertNotEquals((Object)"route1", (Object)routeId, (String)"Should not be named route1");
        Assertions.assertEquals((int)2, (int)this.context.getRouteDefinitions().size());
        Assertions.assertEquals((int)2, (int)this.context.getRoutes().size());
        Assertions.assertEquals((Object)"Started", (Object)this.context.getRouteController().getRouteStatus(routeId).name());
        Assertions.assertEquals((Object)"true", this.context.getRoute(routeId).getProperties().get("template"));
        this.template.sendBody("direct:one", (Object)"Hello Cheese");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)3, (int)this.context.getRoute(routeId).filter("aaa*").size());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.routeTemplate("myTemplate").templateParameter("foo").templateParameter("bar").from("direct:{{foo}}").choice().when((Predicate)this.header("foo")).log("${body}")).id("myLog")).otherwise().to("mock:{{bar}}")).id("end");
            }
        };
    }
}

