/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.TemplatedRouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class RouteTemplatePreconditionTest
extends ContextTestSupport {
    RouteTemplatePreconditionTest() {
    }

    @Test
    void testRouteIncluded() throws Exception {
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplateWithPrecondition").parameter("protocol", (Object)"json").routeId("myRoute").add();
        RouteTemplatePreconditionTest.assertCollectionSize(this.context.getRouteDefinitions(), 1);
        RouteTemplatePreconditionTest.assertCollectionSize(this.context.getRoutes(), 1);
        Assertions.assertNotNull((Object)this.context.getRoute("myRoute"));
        this.getMockEndpoint("mock:out").expectedMessageCount(1);
        this.template.sendBody("direct:in", (Object)"Hello Included Route");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    void testRouteExcluded() {
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplateWithPrecondition").parameter("protocol", (Object)"avro").routeId("myRoute").add();
        RouteTemplatePreconditionTest.assertCollectionSize(this.context.getRouteDefinitions(), 0);
        RouteTemplatePreconditionTest.assertCollectionSize(this.context.getRoutes(), 0);
        Assertions.assertNull((Object)this.context.getRoute("myRoute"));
    }

    @Test
    void testRouteIncludedByDefault() throws Exception {
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplateWithoutPrecondition").routeId("myRoute").add();
        RouteTemplatePreconditionTest.assertCollectionSize(this.context.getRouteDefinitions(), 1);
        RouteTemplatePreconditionTest.assertCollectionSize(this.context.getRoutes(), 1);
        Assertions.assertNotNull((Object)this.context.getRoute("myRoute"));
        this.getMockEndpoint("mock:out").expectedMessageCount(1);
        this.template.sendBody("direct:in", (Object)"Hello Included Route");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.routeTemplate("myTemplateWithPrecondition").templateParameter("protocol").from("direct:in").precondition("'{{protocol}}' == 'json'").to("mock:out");
                this.routeTemplate("myTemplateWithoutPrecondition").from("direct:in").to("mock:out");
            }
        };
    }
}

