/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.TemplatedRouteBuilder;
import org.junit.jupiter.api.Test;

public class RouteTemplateOptionalValueTest
extends ContextTestSupport {
    @Test
    public void testOptionalProvided() throws Exception {
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("foo", (Object)"start").parameter("myRetain", (Object)"1").routeId("myRoute").add();
        this.getMockEndpoint("mock:result?retainFirst=1").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testOptional() throws Exception {
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("foo", (Object)"start2").routeId("myRoute").add();
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start2", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.routeTemplate("myTemplate").templateParameter("foo").templateOptionalParameter("myRetain").from("direct:{{foo}}").to("mock:result?retainFirst={{?myRetain}}");
            }
        };
    }
}

