/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.Map;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteTemplateOnExceptionTest
extends ContextTestSupport {
    @Test
    public void testOnException() throws Exception {
        this.context.addRouteFromTemplate("myRoute", "myTemplate", Map.of("foo", "start"));
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        Exchange out = this.fluentTemplate.withBody((Object)"Hello World").to("direct:start").send();
        Assertions.assertTrue((boolean)out.isRollbackOnly());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testOnExceptionPrefixId() throws Exception {
        this.context.addRouteFromTemplate("myRoute", "myTemplate", "myPrefix", Map.of("foo", "start"));
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        Exchange out = this.fluentTemplate.withBody((Object)"Bye World").to("direct:start").send();
        Assertions.assertTrue((boolean)out.isRollbackOnly());
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)((OnExceptionDefinition)this.routeTemplate("myTemplate").templateParameter("foo").from("direct:{{foo}}").onException(Exception.class).to("mock:error")).markRollbackOnly()).end().throwException((Exception)new IllegalArgumentException("Forced")).to("mock:result");
            }
        };
    }
}

