/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.TemplatedRouteBuilder;
import org.apache.camel.model.ModelLifecycleStrategy;
import org.apache.camel.model.ModelLifecycleStrategySupport;
import org.apache.camel.model.RouteTemplateDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteTemplateModelLifecycleTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testModelLifecycle() throws Exception {
        this.context.addModelLifecycleStrategy((ModelLifecycleStrategy)new ModelLifecycleStrategySupport(){

            public void onAddRouteTemplateDefinition(RouteTemplateDefinition template) {
                template.getRoute().getInput().setUri("seda:{{foo}}");
            }
        });
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.routeTemplate("myTemplate").templateParameter("foo").templateParameter("bar").from("direct:{{foo}}").to("mock:{{bar}}");
            }
        });
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("foo", (Object)"one").parameter("bar", (Object)"result").routeId("myRoute").add();
        this.context.start();
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("seda:one", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        this.context.stop();
    }

    @Test
    public void testModelLifecycleViaHandler() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.routeTemplate("myTemplate").templateParameter("foo").templateParameter("bar").from("direct:{{foo}}").to("mock:{{bar}}");
            }
        });
        this.context.start();
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("foo", (Object)"one").parameter("bar", (Object)"result").routeId("myRoute").handler(template -> template.getRoute().getInput().setUri("seda:{{foo}}")).add();
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("seda:one", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        this.context.stop();
    }
}

