/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RouteTemplateContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.TemplatedRouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteTemplateLocalBeanTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testGlobalBean() throws Exception {
        this.context.getRegistry().bind("myBar", ex -> ex.getMessage().setBody((Object)("Global " + String.valueOf(ex.getMessage().getBody()))));
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.routeTemplate("myTemplate").templateParameter("foo").templateParameter("bar").from("direct:{{foo}}").to("bean:{{bar}}");
            }
        });
        this.context.start();
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("foo", (Object)"one").parameter("bar", (Object)"myBar").routeId("myRoute").add();
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        Object out = this.template.requestBody("direct:one", (Object)"World");
        Assertions.assertEquals((Object)"Global World", (Object)out);
        Assertions.assertNotNull((Object)this.context.getRegistry().lookupByName("myBar"));
        this.context.stop();
    }

    @Test
    public void testLocalBeanInBuilder() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.routeTemplate("myTemplate").templateParameter("foo").templateParameter("bar").from("direct:{{foo}}").to("bean:{{bar}}");
            }
        });
        this.context.start();
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("foo", (Object)"one").parameter("bar", (Object)"myBar").bean("myBar", ex -> ex.getMessage().setBody((Object)("Builder " + String.valueOf(ex.getMessage().getBody())))).routeId("myRoute").add();
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        Object out = this.template.requestBody("direct:one", (Object)"World");
        Assertions.assertEquals((Object)"Builder World", (Object)out);
        Assertions.assertNull((Object)this.context.getRegistry().lookupByName("myBar"));
        this.context.stop();
    }

    @Test
    public void testLocalBeanInBuilderTwo() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.routeTemplate("myTemplate").templateParameter("foo").templateParameter("bar").from("direct:{{foo}}").to("bean:{{bar}}");
            }
        });
        this.context.start();
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("foo", (Object)"one").parameter("bar", (Object)"myBar").bean("myBar", (Object)new BuilderProcessor()).routeId("myRoute").add();
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("foo", (Object)"two").parameter("bar", (Object)"myBar").bean("myBar", (Object)new BuilderTwoProcessor()).routeId("myRoute2").add();
        Assertions.assertEquals((int)2, (int)this.context.getRoutes().size());
        Object out = this.template.requestBody("direct:one", (Object)"World");
        Assertions.assertEquals((Object)"Builder World", (Object)out);
        Object out2 = this.template.requestBody("direct:two", (Object)"Camel");
        Assertions.assertEquals((Object)"Builder2 Camel", (Object)out2);
        Assertions.assertNull((Object)this.context.getRegistry().lookupByName("myBar"));
        this.context.stop();
    }

    @Test
    public void testLocalBeanInConfigure() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.routeTemplate("myTemplate").templateParameter("foo").templateParameter("bar").from("direct:{{foo}}").to("bean:{{bar}}");
            }
        });
        this.context.start();
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("foo", (Object)"one").parameter("bar", (Object)"myBar").configure(rtc -> rtc.bind("myBar", ex -> ex.getMessage().setBody((Object)("Configure " + String.valueOf(ex.getMessage().getBody()) + " from " + String.valueOf(rtc.getProperty("foo")))))).routeId("myRoute").add();
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        Object out = this.template.requestBody("direct:one", (Object)"World");
        Assertions.assertEquals((Object)"Configure World from one", (Object)out);
        Assertions.assertNull((Object)this.context.getRegistry().lookupByName("myBar"));
        this.context.stop();
    }

    @Test
    public void testLocalBeanInConfigureTwo() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.routeTemplate("myTemplate").templateParameter("foo").templateParameter("bar").from("direct:{{foo}}").to("bean:{{bar}}");
            }
        });
        this.context.start();
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("foo", (Object)"one").parameter("bar", (Object)"myBar").configure(rtc -> rtc.bind("myBar", ex -> ex.getMessage().setBody((Object)("Configure " + String.valueOf(ex.getMessage().getBody()) + " from " + String.valueOf(rtc.getProperty("foo")))))).routeId("myRoute").add();
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("foo", (Object)"two").parameter("bar", (Object)"myBar").configure(rtc -> rtc.bind("myBar", Processor.class, ex -> ex.getMessage().setBody((Object)("Configure2 " + String.valueOf(ex.getMessage().getBody()) + " from " + String.valueOf(rtc.getProperty("foo")))))).routeId("myRoute2").add();
        Assertions.assertEquals((int)2, (int)this.context.getRoutes().size());
        Object out = this.template.requestBody("direct:one", (Object)"World");
        Assertions.assertEquals((Object)"Configure World from one", (Object)out);
        Object out2 = this.template.requestBody("direct:two", (Object)"Camel");
        Assertions.assertEquals((Object)"Configure2 Camel from two", (Object)out2);
        Assertions.assertNull((Object)this.context.getRegistry().lookupByName("myBar"));
        this.context.stop();
    }

    @Test
    public void testLocalBeanInTemplateConfigure() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.routeTemplate("myTemplate").templateParameter("foo").templateParameter("bar").configure(rtc -> rtc.bind("myBar", ex -> ex.getMessage().setBody((Object)("Builder " + String.valueOf(ex.getMessage().getBody()))))).from("direct:{{foo}}").to("bean:{{bar}}");
            }
        });
        this.context.start();
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("foo", (Object)"one").parameter("bar", (Object)"myBar").routeId("myRoute").add();
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        Object out = this.template.requestBody("direct:one", (Object)"World");
        Assertions.assertEquals((Object)"Builder World", (Object)out);
        Assertions.assertNull((Object)this.context.getRegistry().lookupByName("myBar"));
        this.context.stop();
    }

    @Test
    public void testLocalBeanInTemplateConfigureTwo() throws Exception {
        final AtomicInteger counter = new AtomicInteger();
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.routeTemplate("myTemplate").templateParameter("foo").templateParameter("bar").configure(rtc -> rtc.bind("myBar", ex -> ex.getMessage().setBody((Object)("Builder" + counter.incrementAndGet() + " " + String.valueOf(ex.getMessage().getBody()))))).from("direct:{{foo}}").to("bean:{{bar}}");
            }
        });
        this.context.start();
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("foo", (Object)"one").parameter("bar", (Object)"myBar").routeId("myRoute").add();
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("foo", (Object)"two").parameter("bar", (Object)"myBar").routeId("myRoute2").add();
        Assertions.assertEquals((int)2, (int)this.context.getRoutes().size());
        Object out = this.template.requestBody("direct:one", (Object)"World");
        Assertions.assertEquals((Object)"Builder1 World", (Object)out);
        Object out2 = this.template.requestBody("direct:two", (Object)"Camel");
        Assertions.assertEquals((Object)"Builder2 Camel", (Object)out2);
        Assertions.assertNull((Object)this.context.getRegistry().lookupByName("myBar"));
        this.context.stop();
    }

    @Test
    public void testLocalBeanInTemplateBeanSupplier() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.routeTemplate("myTemplate").templateParameter("foo").templateParameter("bar").templateBean("myBar", Processor.class, ctx -> ex -> ex.getMessage().setBody((Object)("Builder " + String.valueOf(ex.getMessage().getBody())))).from("direct:{{foo}}").to("bean:{{bar}}");
            }
        });
        this.context.start();
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("foo", (Object)"one").parameter("bar", (Object)"myBar").routeId("myRoute").add();
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        Object out = this.template.requestBody("direct:one", (Object)"World");
        Assertions.assertEquals((Object)"Builder World", (Object)out);
        Assertions.assertNull((Object)this.context.getRegistry().lookupByName("myBar"));
        this.context.stop();
    }

    @Test
    public void testLocalBeanInTemplateBeanSupplierTwo() throws Exception {
        final AtomicInteger counter = new AtomicInteger();
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.routeTemplate("myTemplate").templateParameter("foo").templateParameter("bar").templateBean("myBar", Processor.class, ctx -> ex -> ex.getMessage().setBody((Object)("Builder" + counter.incrementAndGet() + " " + String.valueOf(ex.getMessage().getBody())))).from("direct:{{foo}}").to("bean:{{bar}}");
            }
        });
        this.context.start();
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("foo", (Object)"one").parameter("bar", (Object)"myBar").routeId("myRoute").add();
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("foo", (Object)"two").parameter("bar", (Object)"myBar").routeId("myRoute2").add();
        Assertions.assertEquals((int)2, (int)this.context.getRoutes().size());
        Object out = this.template.requestBody("direct:one", (Object)"World");
        Assertions.assertEquals((Object)"Builder1 World", (Object)out);
        Object out2 = this.template.requestBody("direct:two", (Object)"Camel");
        Assertions.assertEquals((Object)"Builder2 Camel", (Object)out2);
        Assertions.assertNull((Object)this.context.getRegistry().lookupByName("myBar"));
        this.context.stop();
    }

    @Test
    public void testLocalBeanInTemplateBean() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.routeTemplate("myTemplate").templateParameter("foo").templateParameter("bar").templateBean("myBar", () -> ex -> ex.getMessage().setBody((Object)("Builder " + String.valueOf(ex.getMessage().getBody())))).from("direct:{{foo}}").to("bean:{{bar}}");
            }
        });
        this.context.start();
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("foo", (Object)"one").parameter("bar", (Object)"myBar").routeId("myRoute").add();
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        Object out = this.template.requestBody("direct:one", (Object)"World");
        Assertions.assertEquals((Object)"Builder World", (Object)out);
        Assertions.assertNull((Object)this.context.getRegistry().lookupByName("myBar"));
        this.context.stop();
    }

    @Test
    public void testLocalBeanInTemplateBeanTwo() throws Exception {
        final AtomicInteger counter = new AtomicInteger();
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.routeTemplate("myTemplate").templateParameter("foo").templateParameter("bar").templateBean("myBar", () -> ex -> ex.getMessage().setBody((Object)("Builder" + counter.incrementAndGet() + " " + String.valueOf(ex.getMessage().getBody())))).from("direct:{{foo}}").to("bean:{{bar}}");
            }
        });
        this.context.start();
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("foo", (Object)"one").parameter("bar", (Object)"myBar").routeId("myRoute").add();
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("foo", (Object)"two").parameter("bar", (Object)"myBar").routeId("myRoute2").add();
        Assertions.assertEquals((int)2, (int)this.context.getRoutes().size());
        Object out = this.template.requestBody("direct:one", (Object)"World");
        Assertions.assertEquals((Object)"Builder1 World", (Object)out);
        Object out2 = this.template.requestBody("direct:two", (Object)"Camel");
        Assertions.assertEquals((Object)"Builder2 Camel", (Object)out2);
        Assertions.assertNull((Object)this.context.getRegistry().lookupByName("myBar"));
        this.context.stop();
    }

    @Test
    public void testLocalBeanExpression() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.routeTemplate("myTemplate").templateParameter("foo").templateParameter("bar").templateBean("myBar", "bean", RouteTemplateLocalBeanTest.class.getName() + "?method=createBuilderProcessor").from("direct:{{foo}}").to("bean:{{bar}}");
            }
        });
        this.context.start();
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("foo", (Object)"one").parameter("bar", (Object)"myBar").routeId("myRoute").add();
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        Object out = this.template.requestBody("direct:one", (Object)"World");
        Assertions.assertEquals((Object)"Builder World", (Object)out);
        Assertions.assertNull((Object)this.context.getRegistry().lookupByName("myBar"));
        this.context.stop();
    }

    @Test
    public void testLocalBeanExpressionFluent() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteTemplateDefinition)this.routeTemplate("myTemplate").templateParameter("foo").templateParameter("bar").templateBean("myBar").bean(RouteTemplateLocalBeanTest.class, "createBuilderProcessor")).from("direct:{{foo}}").to("bean:{{bar}}");
            }
        });
        this.context.start();
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("foo", (Object)"one").parameter("bar", (Object)"myBar").routeId("myRoute").add();
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        Object out = this.template.requestBody("direct:one", (Object)"World");
        Assertions.assertEquals((Object)"Builder World", (Object)out);
        Assertions.assertNull((Object)this.context.getRegistry().lookupByName("myBar"));
        this.context.stop();
    }

    @Test
    public void testLocalBeanExpressionFluentTwo() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteTemplateDefinition)this.routeTemplate("myTemplate").templateParameter("foo").templateParameter("bar").templateParameter("greeting", "Davs ").templateBean("myBar").bean(RouteTemplateLocalBeanTest.class, "createBuilderProcessorTwo")).from("direct:{{foo}}").to("bean:{{bar}}");
            }
        });
        this.context.start();
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("foo", (Object)"one").parameter("bar", (Object)"myBar").routeId("myRoute").add();
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        Object out = this.template.requestBody("direct:one", (Object)"World");
        Assertions.assertEquals((Object)"Davs Builder2 World", (Object)out);
        Assertions.assertNull((Object)this.context.getRegistry().lookupByName("myBar"));
        this.context.stop();
    }

    @Test
    public void testLocalBeanClassExpressionFluent() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteTemplateDefinition)this.routeTemplate("myTemplate").templateParameter("foo").templateParameter("bar").templateBean("myBar").typeClass(BuilderProcessor.class).end()).from("direct:{{foo}}").to("bean:{{bar}}");
            }
        });
        this.context.start();
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("foo", (Object)"one").parameter("bar", (Object)"myBar").routeId("myRoute").add();
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        Object out = this.template.requestBody("direct:one", (Object)"World");
        Assertions.assertEquals((Object)"Builder World", (Object)out);
        Assertions.assertNull((Object)this.context.getRegistry().lookupByName("myBar"));
        this.context.stop();
    }

    @Test
    public void testLocalBeanClassAsString() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteTemplateDefinition)this.routeTemplate("myTemplate").templateParameter("foo").templateParameter("bar").templateBean("myBar").type(BuilderProcessor.class.getName()).end()).from("direct:{{foo}}").to("bean:{{bar}}");
            }
        });
        this.context.start();
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("foo", (Object)"one").parameter("bar", (Object)"myBar").routeId("myRoute").add();
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        Object out = this.template.requestBody("direct:one", (Object)"World");
        Assertions.assertEquals((Object)"Builder World", (Object)out);
        Assertions.assertNull((Object)this.context.getRegistry().lookupByName("myBar"));
        this.context.stop();
    }

    @Test
    public void testLocalBeanClassPropertiesFluent() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteTemplateDefinition)this.routeTemplate("myTemplate").templateParameter("foo").templateParameter("bar").templateParameter("hi").templateBean("myBar").property("prefix", "{{hi}}").typeClass(BuilderThreeProcessor.class).end()).from("direct:{{foo}}").to("bean:{{bar}}");
            }
        });
        this.context.start();
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("foo", (Object)"one").parameter("bar", (Object)"myBar").parameter("hi", (Object)"Davs").routeId("myRoute").add();
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        Object out = this.template.requestBody("direct:one", (Object)"World");
        Assertions.assertEquals((Object)"DavsBuilder3 World", (Object)out);
        Assertions.assertNull((Object)this.context.getRegistry().lookupByName("myBar"));
        this.context.stop();
    }

    @Test
    public void testLocalBeanMemorize() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)((RouteTemplateDefinition)this.routeTemplate("myTemplate").templateParameter("foo").templateParameter("bar").templateParameter("hi").templateBean("myBar").property("prefix", "{{hi}}").typeClass(BuilderThreeProcessor.class).end()).from("direct:{{foo}}").to("bean:{{bar}}")).to("bean:{{bar}}?method=process")).to("mock:result");
            }
        });
        this.context.start();
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("foo", (Object)"one").parameter("bar", (Object)"myBar").parameter("hi", (Object)"Davs").routeId("myRoute").add();
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"DavsBuilder3 DavsBuilder3 World"});
        mock.expectedHeaderReceived("counter", (Object)2);
        Object out = this.template.requestBody("direct:one", (Object)"World");
        Assertions.assertEquals((Object)"DavsBuilder3 DavsBuilder3 World", (Object)out);
        this.assertMockEndpointsSatisfied();
        Assertions.assertNull((Object)this.context.getRegistry().lookupByName("myBar"));
        this.context.stop();
    }

    @Test
    public void testLocalBeanFactoryMethodInType() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteTemplateDefinition)this.routeTemplate("myTemplate").templateParameter("foo").templateParameter("bar").templateBean("myBar").type("#class:org.apache.camel.builder.RouteTemplateLocalBeanTest#createBuilderProcessorThree('MyPrefix ')").end()).from("direct:{{foo}}").to("bean:{{bar}}");
            }
        });
        this.context.start();
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("foo", (Object)"one").parameter("bar", (Object)"myBar").routeId("myRoute").add();
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        Object out = this.template.requestBody("direct:one", (Object)"World");
        Assertions.assertEquals((Object)"MyPrefix Builder3 World", (Object)out);
        Assertions.assertNull((Object)this.context.getRegistry().lookupByName("myBar"));
        this.context.stop();
    }

    @Test
    public void testLocalBeanFactoryMethod() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteTemplateDefinition)this.routeTemplate("myTemplate").templateParameter("foo").templateParameter("bar").templateBean("myBar").type("#class:org.apache.camel.builder.RouteTemplateLocalBeanTest").factoryMethod("createBuilderProcessorThree('MyPrefix ')").end()).from("direct:{{foo}}").to("bean:{{bar}}");
            }
        });
        this.context.start();
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("foo", (Object)"one").parameter("bar", (Object)"myBar").routeId("myRoute").add();
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        Object out = this.template.requestBody("direct:one", (Object)"World");
        Assertions.assertEquals((Object)"MyPrefix Builder3 World", (Object)out);
        Assertions.assertNull((Object)this.context.getRegistry().lookupByName("myBar"));
        this.context.stop();
    }

    @Test
    public void testLocalBeanConstructorParameterInType() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteTemplateDefinition)this.routeTemplate("myTemplate").templateParameter("foo").templateParameter("bar").templateBean("myBar").type("#class:org.apache.camel.builder.MyConstructorProcessor('MyCtr ')").end()).from("direct:{{foo}}").to("bean:{{bar}}");
            }
        });
        this.context.start();
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("foo", (Object)"one").parameter("bar", (Object)"myBar").routeId("myRoute").add();
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        Object out = this.template.requestBody("direct:one", (Object)"World");
        Assertions.assertEquals((Object)"MyCtr World", (Object)out);
        Assertions.assertNull((Object)this.context.getRegistry().lookupByName("myBar"));
        this.context.stop();
    }

    @Test
    public void testLocalBeanConstructorParameter() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteTemplateDefinition)this.routeTemplate("myTemplate").templateParameter("foo").templateParameter("bar").templateBean("myBar").type("#class:org.apache.camel.builder.MyConstructorProcessor").constructor(Integer.valueOf(0), "'MyCtr '").end()).from("direct:{{foo}}").to("bean:{{bar}}");
            }
        });
        this.context.start();
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("foo", (Object)"one").parameter("bar", (Object)"myBar").routeId("myRoute").add();
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        Object out = this.template.requestBody("direct:one", (Object)"World");
        Assertions.assertEquals((Object)"MyCtr World", (Object)out);
        Assertions.assertNull((Object)this.context.getRegistry().lookupByName("myBar"));
        this.context.stop();
    }

    public Processor createBuilderProcessor() {
        return new BuilderProcessor();
    }

    public Processor createBuilderProcessorTwo(RouteTemplateContext rtc) {
        return new BuilderTwoProcessor((String)rtc.getProperty("greeting", String.class));
    }

    public static Processor createBuilderProcessorThree(String prefix) {
        BuilderThreeProcessor answer = new BuilderThreeProcessor();
        answer.setPrefix(prefix);
        return answer;
    }

    public static class BuilderProcessor
    implements Processor {
        public void process(Exchange exchange) {
            exchange.getMessage().setBody((Object)("Builder " + String.valueOf(exchange.getMessage().getBody())));
        }
    }

    public static class BuilderTwoProcessor
    implements Processor {
        private String prefix = "";

        public BuilderTwoProcessor() {
        }

        public BuilderTwoProcessor(String prefix) {
            this.prefix = prefix;
        }

        public void process(Exchange exchange) {
            exchange.getMessage().setBody((Object)(this.prefix + "Builder2 " + String.valueOf(exchange.getMessage().getBody())));
        }
    }

    public static class BuilderThreeProcessor
    implements Processor {
        private String prefix = "";
        private int counter;

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public void process(Exchange exchange) {
            ++this.counter;
            exchange.getMessage().setBody((Object)(this.prefix + "Builder3 " + String.valueOf(exchange.getMessage().getBody())));
            exchange.getMessage().setHeader("counter", (Object)this.counter);
        }
    }
}

