/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.Arrays;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.TemplatedRouteBuilder;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.RouteConfigurationDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.RouteTemplateParameterDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteTemplateInterceptFromAndInterceptSendToEndpointWithPlaceholderTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testCreateRouteFromRouteTemplate() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.routeTemplate("myTemplate").templateParameter("foo").templateParameter("bar").from("direct:{{foo}}").to("mock:{{bar}}");
                RouteConfigurationDefinition routeConfigurationDefinition = new RouteConfigurationDefinition();
                routeConfigurationDefinition.interceptFrom("direct:intercepted-from").to("mock:intercepted-from");
                ((InterceptSendToEndpointDefinition)routeConfigurationDefinition.interceptSendToEndpoint("mock:intercepted-send").to("mock:intercepted-send-to-before")).afterUri("mock:intercepted-send-to-after");
                RouteTemplateInterceptFromAndInterceptSendToEndpointWithPlaceholderTest.this.context.addRouteConfiguration(routeConfigurationDefinition);
            }
        });
        Assertions.assertEquals((int)1, (int)this.context.getRouteTemplateDefinitions().size());
        RouteTemplateDefinition routeTemplate = this.context.getRouteTemplateDefinition("myTemplate");
        Assertions.assertEquals((Object)"foo", (Object)((RouteTemplateParameterDefinition)routeTemplate.getTemplateParameters().get(0)).getName());
        Assertions.assertEquals((Object)"bar", (Object)((RouteTemplateParameterDefinition)routeTemplate.getTemplateParameters().get(1)).getName());
        for (String uriSuffix : Arrays.asList("from", "send-to-before", "send-to-after")) {
            this.getMockEndpoint("mock:intercepted-" + uriSuffix).expectedBodiesReceived(new Object[]{"Hello Intercepted"});
        }
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").routeId("intercepted").parameter("foo", (Object)"intercepted-from").parameter("bar", (Object)"intercepted-send").add();
        this.context.start();
        Assertions.assertEquals((int)1, (int)this.context.getRouteDefinitions().size());
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        Assertions.assertEquals((Object)"Started", (Object)this.context.getRouteController().getRouteStatus("intercepted").name());
        Assertions.assertEquals((Object)"true", this.context.getRoute("intercepted").getProperties().get("template"));
        this.template.sendBody("direct:intercepted-from", (Object)"Hello Intercepted");
        this.assertMockEndpointsSatisfied();
        this.context.stop();
    }
}

