/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.List;
import org.apache.camel.Channel;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.engine.DefaultRoute;
import org.apache.camel.model.errorhandler.NoErrorHandlerDefinition;
import org.apache.camel.model.errorhandler.RefErrorHandlerDefinition;
import org.apache.camel.processor.errorhandler.NoErrorHandler;
import org.apache.camel.util.CollectionHelper;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;

public class RouteTemplateErrorHandlerTest {
    @Test
    public void testDefineRouteTemplate() throws Exception {
        try (DefaultCamelContext context = new DefaultCamelContext();){
            context.getCamelContextExtension().getRegistry().bind("myErrorHandler", (Object)new NoErrorHandlerDefinition());
            context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() {
                    this.errorHandler("myErrorHandler");
                    this.routeTemplate("myTemplate").templateParameter("foo").templateParameter("bar").from("direct:{{foo}}").to("mock:{{bar}}");
                    this.from("direct:_r").to("mock:_r");
                }
            });
            ((ObjectAssert)Assertions.assertThat((List)context.getRouteDefinitions()).first()).satisfies(new ThrowingConsumer[]{d -> Assertions.assertThat((Object)d.getErrorHandlerFactory()).isInstanceOfSatisfying(RefErrorHandlerDefinition.class, h -> Assertions.assertThat((String)h.getRef()).isEqualTo("myErrorHandler"))});
            ((ObjectAssert)Assertions.assertThat((List)context.getRouteTemplateDefinitions()).first()).satisfies(new ThrowingConsumer[]{d -> Assertions.assertThat((Object)d.route().getErrorHandlerFactory()).isInstanceOfSatisfying(RefErrorHandlerDefinition.class, h -> Assertions.assertThat((String)h.getRef()).isEqualTo("myErrorHandler"))});
            context.addRouteFromTemplate("myId", "myTemplate", CollectionHelper.mapOf((Object)"foo", (Object)"f", (Object[])new Object[]{"bar", "b"}));
            context.start();
            Assertions.assertThat((List)context.getRoutes()).allSatisfy(r -> Assertions.assertThat((Object)r).isInstanceOfSatisfying(DefaultRoute.class, dr -> {
                Channel channel = TestSupport.unwrapChannel(r.getProcessor());
                Assertions.assertThat((Object)channel).isNotNull();
                Assertions.assertThat((Object)channel.getErrorHandler()).isInstanceOf(NoErrorHandler.class);
            }));
        }
    }
}

