/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.HashMap;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.HasId;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteTemplateDuplicateIdIssueTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    void shouldNotFailDueToDuplicatedNodeId() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.routeTemplate("myTemplate").templateParameter("input").from("direct:{{input}}").recipientList((Expression)this.constant("mock:a,mock:b")).parallelProcessing().to("mock:result");
            }
        });
        HashMap<String, String> one = new HashMap<String, String>();
        one.put("input", "a");
        this.context.addRouteFromTemplate("testRouteId1", "myTemplate", one);
        HashMap<String, String> two = new HashMap<String, String>();
        two.put("input", "b");
        this.context.addRouteFromTemplate("testRouteId2", "myTemplate", two);
        Assertions.assertDoesNotThrow(() -> this.context.start(), (String)"Route creation should not fail");
        List<Processor> processors = this.getProcessors(".*recipientList.*");
        Assertions.assertEquals((int)2, (int)processors.size());
        Processor p1 = processors.get(0);
        Processor p2 = processors.get(1);
        Assertions.assertNotNull((Object)p1);
        Assertions.assertNotNull((Object)p2);
        Assertions.assertNotSame((Object)p1, (Object)p2);
        Assertions.assertNotEquals((Object)((HasId)p1).getId(), (Object)((HasId)p2).getId());
        this.context.stop();
    }
}

