/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.HashMap;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.RouteTemplateParameterDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteTemplateDefaultValueTest
extends ContextTestSupport {
    @Test
    public void testDefineRouteTemplate() {
        Assertions.assertEquals((int)1, (int)this.context.getRouteTemplateDefinitions().size());
        RouteTemplateDefinition routeTemplate = this.context.getRouteTemplateDefinition("myTemplate");
        Assertions.assertEquals((Object)"foo", (Object)((RouteTemplateParameterDefinition)routeTemplate.getTemplateParameters().get(0)).getName());
        Assertions.assertNull((Object)((RouteTemplateParameterDefinition)routeTemplate.getTemplateParameters().get(0)).getDefaultValue());
        Assertions.assertEquals((Object)"bar", (Object)((RouteTemplateParameterDefinition)routeTemplate.getTemplateParameters().get(1)).getName());
        Assertions.assertEquals((Object)"cake", (Object)((RouteTemplateParameterDefinition)routeTemplate.getTemplateParameters().get(1)).getDefaultValue());
    }

    @Test
    public void testCreateRouteFromRouteTemplate() throws Exception {
        Assertions.assertEquals((int)1, (int)this.context.getRouteTemplateDefinitions().size());
        RouteTemplateDefinition routeTemplate = this.context.getRouteTemplateDefinition("myTemplate");
        Assertions.assertEquals((Object)"foo", (Object)((RouteTemplateParameterDefinition)routeTemplate.getTemplateParameters().get(0)).getName());
        Assertions.assertEquals((Object)"bar", (Object)((RouteTemplateParameterDefinition)routeTemplate.getTemplateParameters().get(1)).getName());
        this.getMockEndpoint("mock:cheese").expectedBodiesReceived(new Object[]{"Hello Cheese"});
        this.getMockEndpoint("mock:cake").expectedBodiesReceived(new Object[]{"Hello Cake"});
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("foo", "one");
        parameters.put("bar", "cheese");
        this.context.addRouteFromTemplate("first", "myTemplate", parameters);
        parameters.clear();
        parameters.put("foo", "two");
        this.context.addRouteFromTemplate("second", "myTemplate", parameters);
        Assertions.assertEquals((int)2, (int)this.context.getRouteDefinitions().size());
        Assertions.assertEquals((int)2, (int)this.context.getRoutes().size());
        Assertions.assertEquals((Object)"Started", (Object)this.context.getRouteController().getRouteStatus("first").name());
        Assertions.assertEquals((Object)"Started", (Object)this.context.getRouteController().getRouteStatus("second").name());
        Assertions.assertEquals((Object)"true", this.context.getRoute("first").getProperties().get("template"));
        Assertions.assertEquals((Object)"true", this.context.getRoute("second").getProperties().get("template"));
        this.template.sendBody("direct:one", (Object)"Hello Cheese");
        this.template.sendBody("direct:two", (Object)"Hello Cake");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testCreateRouteFromRouteTemplateMissingParameter() {
        Assertions.assertEquals((int)1, (int)this.context.getRouteTemplateDefinitions().size());
        RouteTemplateDefinition routeTemplate = this.context.getRouteTemplateDefinition("myTemplate");
        Assertions.assertEquals((Object)"foo", (Object)((RouteTemplateParameterDefinition)routeTemplate.getTemplateParameters().get(0)).getName());
        Assertions.assertEquals((Object)"bar", (Object)((RouteTemplateParameterDefinition)routeTemplate.getTemplateParameters().get(1)).getName());
        HashMap parameters = new HashMap();
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.context.addRouteFromTemplate(null, "myTemplate", parameters), (String)"Should throw exception");
        Assertions.assertEquals((Object)"Route template myTemplate the following mandatory parameters must be provided: foo", (Object)e.getMessage());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.routeTemplate("myTemplate").templateParameter("foo").templateParameter("bar", "cake").from("direct:{{foo}}").to("mock:{{bar}}");
            }
        };
    }
}

