/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spi.RouteTemplateParameterSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteTemplateCustomSourceTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getRegistry().bind("mySource", (Object)new MyRouteTemplateParameterSource());
        return context;
    }

    @Test
    public void testCreateRouteFromRouteTemplateMissingParameter() throws Exception {
        Assertions.assertEquals((int)1, (int)this.context.getRouteTemplateDefinitions().size());
        Assertions.assertEquals((int)2, (int)this.context.getRoutes().size());
        MockEndpoint mock = this.getMockEndpoint("mock:cheese");
        mock.expectedBodiesReceived(new Object[]{"Hello Foo", "Hello Bar"});
        this.template.sendBody("direct:one", (Object)"Hello Foo");
        this.template.sendBody("direct:two", (Object)"Hello Bar");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.routeTemplate("myTemplate").templateParameter("foo").templateParameter("bar").from("direct:{{foo}}").to("mock:{{bar}}");
            }
        };
    }

    private static class MyRouteTemplateParameterSource
    implements RouteTemplateParameterSource {
        private MyRouteTemplateParameterSource() {
        }

        public Map<String, Object> parameters(String routeId) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("templateId", "myTemplate");
            map.put("bar", "cheese");
            if ("A".equals(routeId)) {
                map.put("foo", "one");
            } else {
                map.put("foo", "two");
            }
            return map;
        }

        public Set<String> routeIds() {
            return Stream.of("A", "B").collect(Collectors.toSet());
        }
    }
}

