/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.stream.IntStream;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.util.CollectionHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteTemplateConverterTest
extends ContextTestSupport {
    @Test
    public void testCreateRouteFromRouteTemplateWithDefaultConverter() throws Exception {
        this.context.addRouteTemplateDefinitionConverter("myTemplate1", RouteTemplateDefinition.Converter.DEFAULT_CONVERTER);
        this.context.addRouteFromTemplate("first", "myTemplate1", CollectionHelper.mapOf((Object)"foo", (Object)"one", (Object[])new Object[]{"bar", "cheese"}));
        Assertions.assertEquals((int)1, (int)this.context.getRouteDefinitions().size());
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        Assertions.assertEquals((Object)"direct:{{foo}}", (Object)this.context.getRouteDefinition("first").getInput().getEndpointUri());
        Assertions.assertEquals((Object)"direct://one", (Object)this.context.getRoute("first").getEndpoint().getEndpointUri());
    }

    @Test
    public void testCreateRouteFromRouteTemplateWithCustomConverter() throws Exception {
        this.context.addRouteTemplateDefinitionConverter("myTemplate1", (template, params) -> {
            RouteDefinition def = template.asRouteDefinition();
            String inUri = def.getInput().getEndpointUri();
            def.setInput(null);
            def.setInput(new FromDefinition(inUri + "?timeout=60s"));
            return def;
        });
        this.context.addRouteFromTemplate("first", "myTemplate1", CollectionHelper.mapOf((Object)"foo", (Object)"one", (Object[])new Object[]{"bar", "cheese"}));
        Assertions.assertEquals((int)1, (int)this.context.getRouteDefinitions().size());
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        Assertions.assertEquals((Object)"direct:{{foo}}?timeout=60s", (Object)this.context.getRouteDefinition("first").getInput().getEndpointUri());
        Assertions.assertEquals((Object)"direct://one?timeout=60s", (Object)this.context.getRoute("first").getEndpoint().getEndpointUri());
    }

    @Test
    public void testCreateRouteFromRouteTemplateWithCustomConverterAndProperties() throws Exception {
        this.context.addRouteTemplateDefinitionConverter("myTemplate1", (template, params) -> {
            Object timeout = params.remove("timeout");
            Assertions.assertNotNull(timeout);
            RouteDefinition def = template.asRouteDefinition();
            String inUri = def.getInput().getEndpointUri();
            def.setInput(null);
            def.setInput(new FromDefinition(inUri + "?timeout=" + String.valueOf(timeout)));
            return def;
        });
        this.context.addRouteFromTemplate("first", "myTemplate1", CollectionHelper.mapOf((Object)"foo", (Object)"one", (Object[])new Object[]{"bar", "cheese", "timeout", "60s"}));
        Assertions.assertEquals((int)1, (int)this.context.getRouteDefinitions().size());
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        Assertions.assertEquals((Object)"direct:{{foo}}?timeout=60s", (Object)this.context.getRouteDefinition("first").getInput().getEndpointUri());
        Assertions.assertEquals((Object)"direct://one?timeout=60s", (Object)this.context.getRoute("first").getEndpoint().getEndpointUri());
    }

    @Test
    public void testCreateRouteFromRouteTemplateWithCustomConverterPatter() {
        this.context.addRouteTemplateDefinitionConverter("myTemplate[12]", (template, params) -> {
            RouteDefinition def = template.asRouteDefinition();
            String inUri = def.getInput().getEndpointUri();
            def.setInput(null);
            def.setInput(new FromDefinition(inUri + "?timeout=60s"));
            return def;
        });
        IntStream.of(1, 2, 3).mapToObj(Integer::toString).forEach(index -> {
            try {
                this.context.addRouteFromTemplate(index, "myTemplate" + index, CollectionHelper.mapOf((Object)"foo", (Object)index, (Object[])new Object[]{"bar", "cheese"}));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        Assertions.assertEquals((int)3, (int)this.context.getRouteDefinitions().size());
        Assertions.assertEquals((int)3, (int)this.context.getRoutes().size());
        Assertions.assertEquals((Object)"direct:{{foo}}?timeout=60s", (Object)this.context.getRouteDefinition("1").getInput().getEndpointUri());
        Assertions.assertEquals((Object)"direct://1?timeout=60s", (Object)this.context.getRoute("1").getEndpoint().getEndpointUri());
        Assertions.assertEquals((Object)"direct:{{foo}}?timeout=60s", (Object)this.context.getRouteDefinition("2").getInput().getEndpointUri());
        Assertions.assertEquals((Object)"direct://2?timeout=60s", (Object)this.context.getRoute("2").getEndpoint().getEndpointUri());
        Assertions.assertEquals((Object)"direct:{{foo}}", (Object)this.context.getRouteDefinition("3").getInput().getEndpointUri());
        Assertions.assertEquals((Object)"direct://3", (Object)this.context.getRoute("3").getEndpoint().getEndpointUri());
    }

    @Test
    public void testCreateRouteFromRouteTemplateWithCustomConverterGlob() {
        this.context.addRouteTemplateDefinitionConverter("*", (template, params) -> {
            RouteDefinition def = template.asRouteDefinition();
            String inUri = def.getInput().getEndpointUri();
            def.setInput(null);
            def.setInput(new FromDefinition(inUri + "?timeout=60s"));
            return def;
        });
        IntStream.of(1, 2, 3).mapToObj(Integer::toString).forEach(index -> {
            try {
                this.context.addRouteFromTemplate(index, "myTemplate" + index, CollectionHelper.mapOf((Object)"foo", (Object)index, (Object[])new Object[]{"bar", "cheese"}));
                Assertions.assertEquals((Object)"direct:{{foo}}?timeout=60s", (Object)this.context.getRouteDefinition(index).getInput().getEndpointUri());
                Assertions.assertEquals((Object)("direct://" + index + "?timeout=60s"), (Object)this.context.getRoute(index).getEndpoint().getEndpointUri());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.routeTemplate("myTemplate1").templateParameter("foo").templateParameter("bar").from("direct:{{foo}}").to("mock:{{bar}}");
                this.routeTemplate("myTemplate2").templateParameter("foo").templateParameter("bar").from("direct:{{foo}}").to("mock:{{bar}}");
                this.routeTemplate("myTemplate3").templateParameter("foo").templateParameter("bar").from("direct:{{foo}}").to("mock:{{bar}}");
            }
        };
    }
}

