/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.TemplatedRouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.junit.jupiter.api.Test;

class RouteTemplateChoicePredicateTest
extends ContextTestSupport {
    RouteTemplateChoicePredicateTest() {
    }

    @Test
    void testRed() throws Exception {
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("start", (Object)"start").parameter("color", (Object)"red").routeId("myRoute").add();
        this.getMockEndpoint("mock:other").expectedMessageCount(0);
        this.getMockEndpoint("mock:red").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello Red");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    void testBlue() throws Exception {
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("start", (Object)"start").parameter("color", (Object)"blue").routeId("myRoute").add();
        this.getMockEndpoint("mock:other").expectedMessageCount(1);
        this.getMockEndpoint("mock:red").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello Blue");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    void testRedAndBlue() throws Exception {
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("start", (Object)"start1").parameter("color", (Object)"blue").routeId("myRoute1").add();
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("start", (Object)"start2").parameter("color", (Object)"red").routeId("myRoute2").add();
        this.getMockEndpoint("mock:other").expectedMessageCount(1);
        this.getMockEndpoint("mock:red").expectedMessageCount(1);
        this.template.sendBody("direct:start1", (Object)"Hello Red");
        this.template.sendBody("direct:start2", (Object)"Hello Bue");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)this.routeTemplate("myTemplate").templateParameter("start").templateParameter("color").from("direct:{{start}}").choice().when((Predicate)this.simple("'{{color}}' == 'red'")).to("mock:red")).otherwise().to("mock:other")).end().to("mock:end");
            }
        };
    }
}

