/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.TemplatedRouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.junit.jupiter.api.Test;

class RouteTemplateChoiceInPreconditionModeTest
extends ContextTestSupport {
    RouteTemplateChoiceInPreconditionModeTest() {
    }

    @Test
    void testRed() throws Exception {
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("red", (Object)"true").parameter("blue", (Object)"false").routeId("myRoute").add();
        this.getMockEndpoint("mock:end").expectedMessageCount(1);
        this.getMockEndpoint("mock:red").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello Red");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    void testBlue() throws Exception {
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("red", (Object)"false").parameter("blue", (Object)"true").routeId("myRoute").add();
        this.getMockEndpoint("mock:end").expectedMessageCount(1);
        this.getMockEndpoint("mock:blue").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello Red");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    void testNotProvidedBlue() throws Exception {
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").parameter("blue", (Object)"true").routeId("myRoute").add();
        this.getMockEndpoint("mock:end").expectedMessageCount(1);
        this.getMockEndpoint("mock:blue").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello Red");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    void testNotProvided() throws Exception {
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").routeId("myRoute").add();
        this.getMockEndpoint("mock:end").expectedMessageCount(1);
        this.getMockEndpoint("mock:red").expectedMessageCount(0);
        this.getMockEndpoint("mock:blue").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)this.routeTemplate("myTemplate").templateOptionalParameter("red").templateOptionalParameter("blue").from("direct:start").choice().precondition().when((Predicate)this.simple("{{?red}}")).to("mock:red")).when((Predicate)this.simple("{{?blue}}")).to("mock:blue")).end().to("mock:end");
            }
        };
    }
}

