/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.TemplatedRouteBuilder;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.RouteTemplateParameterDefinition;
import org.apache.camel.util.CollectionHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteTemplateBeforeContextStartingTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testCreateRouteFromRouteTemplate() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.routeTemplate("myTemplate").templateParameter("foo").templateParameter("bar").from("direct:{{foo}}").to("mock:{{bar}}");
            }
        });
        Assertions.assertEquals((int)1, (int)this.context.getRouteTemplateDefinitions().size());
        RouteTemplateDefinition routeTemplate = this.context.getRouteTemplateDefinition("myTemplate");
        Assertions.assertEquals((Object)"foo", (Object)((RouteTemplateParameterDefinition)routeTemplate.getTemplateParameters().get(0)).getName());
        Assertions.assertEquals((Object)"bar", (Object)((RouteTemplateParameterDefinition)routeTemplate.getTemplateParameters().get(1)).getName());
        this.getMockEndpoint("mock:cheese").expectedBodiesReceived(new Object[]{"Hello Cheese"});
        this.getMockEndpoint("mock:cake").expectedBodiesReceived(new Object[]{"Hello Cake"});
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").routeId("first").parameter("foo", (Object)"one").parameter("bar", (Object)"cheese").add();
        TemplatedRouteBuilder.builder((CamelContext)this.context, (String)"myTemplate").routeId("second").parameters(CollectionHelper.mapOf((Object)"foo", (Object)"two", (Object[])new Object[]{"bar", "cake"})).add();
        this.context.start();
        Assertions.assertEquals((int)2, (int)this.context.getRouteDefinitions().size());
        Assertions.assertEquals((int)2, (int)this.context.getRoutes().size());
        Assertions.assertEquals((Object)"Started", (Object)this.context.getRouteController().getRouteStatus("first").name());
        Assertions.assertEquals((Object)"Started", (Object)this.context.getRouteController().getRouteStatus("second").name());
        Assertions.assertEquals((Object)"true", this.context.getRoute("first").getProperties().get("template"));
        Assertions.assertEquals((Object)"true", this.context.getRoute("second").getProperties().get("template"));
        this.template.sendBody("direct:one", (Object)"Hello Cheese");
        this.template.sendBody("direct:two", (Object)"Hello Cake");
        this.assertMockEndpointsSatisfied();
        this.context.stop();
    }
}

