/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.HashMap;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.RouteTemplateParameterDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteTemplateAndExistingRouteTest
extends ContextTestSupport {
    @Test
    public void testDefineRouteTemplate() {
        Assertions.assertEquals((int)1, (int)this.context.getRouteTemplateDefinitions().size());
        RouteTemplateDefinition routeTemplate = this.context.getRouteTemplateDefinition("myTemplate");
        Assertions.assertEquals((Object)"foo", (Object)((RouteTemplateParameterDefinition)routeTemplate.getTemplateParameters().get(0)).getName());
        Assertions.assertEquals((Object)"greeting", (Object)((RouteTemplateParameterDefinition)routeTemplate.getTemplateParameters().get(1)).getName());
    }

    @Test
    public void testCreateRouteFromRouteTemplate() throws Exception {
        Assertions.assertEquals((int)1, (int)this.context.getRouteTemplateDefinitions().size());
        RouteTemplateDefinition routeTemplate = this.context.getRouteTemplateDefinition("myTemplate");
        Assertions.assertEquals((Object)"foo", (Object)((RouteTemplateParameterDefinition)routeTemplate.getTemplateParameters().get(0)).getName());
        Assertions.assertEquals((Object)"greeting", (Object)((RouteTemplateParameterDefinition)routeTemplate.getTemplateParameters().get(1)).getName());
        this.getMockEndpoint("mock:common").expectedBodiesReceived(new Object[]{"Hello Camel", "Hello World"});
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("foo", "one");
        parameters.put("greeting", "Camel");
        this.context.addRouteFromTemplate("first", "myTemplate", parameters);
        parameters.put("foo", "two");
        parameters.put("greeting", "World");
        this.context.addRouteFromTemplate("second", "myTemplate", parameters);
        Assertions.assertEquals((int)3, (int)this.context.getRouteDefinitions().size());
        Assertions.assertEquals((int)3, (int)this.context.getRoutes().size());
        Assertions.assertEquals((Object)"Started", (Object)this.context.getRouteController().getRouteStatus("first").name());
        Assertions.assertEquals((Object)"Started", (Object)this.context.getRouteController().getRouteStatus("second").name());
        Assertions.assertEquals((Object)"Started", (Object)this.context.getRouteController().getRouteStatus("common").name());
        this.template.sendBody("direct:one", (Object)"Camel");
        this.template.sendBody("direct:two", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.routeTemplate("myTemplate").templateParameter("foo").templateParameter("greeting").description("Route saying {{greeting}}").from("direct:{{foo}}").transform((Expression)this.simple("Hello {{greeting}}"))).to("direct:common");
                this.from("direct:common").routeId("common").to("mock:common");
            }
        };
    }
}

