/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RoutePrefixIdOnExceptionTest
extends ContextTestSupport {
    @Test
    public void testOnException() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        Exchange out = this.fluentTemplate.withBody((Object)"Hello World").to("direct:start").send();
        Assertions.assertTrue((boolean)out.isRollbackOnly());
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)((OnExceptionDefinition)this.from("direct:start").nodePrefixId("myPrefix").onException(Exception.class).to("mock:error")).markRollbackOnly()).end().throwException((Exception)new IllegalArgumentException("Forced")).to("mock:result");
            }
        };
    }
}

