/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ModelLifecycleStrategy;
import org.apache.camel.model.ModelLifecycleStrategySupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteModelLifecycleTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testModelLifecycle() throws Exception {
        this.context.addModelLifecycleStrategy((ModelLifecycleStrategy)new ModelLifecycleStrategySupport(){

            public void onAddRouteDefinition(RouteDefinition route) {
                route.getInput().setUri("direct:two");
            }
        });
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:one").to("mock:result");
            }
        });
        this.context.start();
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:two", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        this.context.stop();
    }
}

