/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Test;

public class RouteBuilderAddRoutesTest
extends ContextTestSupport {
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.interceptSendToEndpoint("mock:result").transform((Expression)this.constant("Foo was here"));
                this.from("direct:foo").to("mock:foo");
                this.from("direct:start").to("mock:result");
            }
        };
    }

    @Test
    public void testAddRoutes() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Foo was here"});
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:foo", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }
}

