/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.Arrays;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.Builder;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.support.Animal;
import org.apache.camel.support.DefaultExchange;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PredicateBuilderTest
extends TestSupport {
    protected final Exchange exchange = new DefaultExchange((CamelContext)new DefaultCamelContext());

    @Test
    public void testRegexPredicates() {
        this.assertMatches(PredicateBuilderTest.header("location").regex("[a-zA-Z]+,London,UK"));
        this.assertDoesNotMatch(PredicateBuilderTest.header("location").regex("[a-zA-Z]+,Westminster,[a-zA-Z]+"));
    }

    @Test
    public void testPredicates() {
        this.assertMatches(PredicateBuilderTest.header("name").isEqualTo((Object)Builder.constant((Object)"James")));
        this.assertMatches(PredicateBuilder.not((Predicate)PredicateBuilderTest.header("name").isEqualTo((Object)Builder.constant((Object)"Claus"))));
        this.assertMatches(PredicateBuilderTest.header("size").isEqualTo((Object)10));
        this.assertMatches(PredicateBuilderTest.header("size").isEqualTo((Object)"10"));
    }

    @Test
    public void testFailingPredicates() {
        this.assertDoesNotMatch(PredicateBuilderTest.header("name").isEqualTo((Object)Builder.constant((Object)"Hiram")));
        this.assertDoesNotMatch(PredicateBuilderTest.header("size").isGreaterThan((Object)Builder.constant((Object)100)));
        this.assertDoesNotMatch(PredicateBuilder.not((Predicate)PredicateBuilderTest.header("size").isLessThan((Object)Builder.constant((Object)100))));
    }

    @Test
    public void testCompoundOrPredicates() {
        Predicate p1 = PredicateBuilderTest.header("name").isEqualTo((Object)Builder.constant((Object)"Hiram"));
        Predicate p2 = PredicateBuilderTest.header("size").isGreaterThanOrEqualTo((Object)Builder.constant((Object)10));
        Predicate or = PredicateBuilder.or((Predicate)p1, (Predicate)p2);
        this.assertMatches(or);
    }

    @Test
    public void testCompoundAndPredicates() {
        Predicate p1 = PredicateBuilderTest.header("name").isEqualTo((Object)Builder.constant((Object)"James"));
        Predicate p2 = PredicateBuilderTest.header("size").isGreaterThanOrEqualTo((Object)Builder.constant((Object)10));
        Predicate and = PredicateBuilder.and((Predicate)p1, (Predicate)p2);
        this.assertMatches(and);
    }

    @Test
    public void testCompoundAndPredicatesVarargs() {
        Predicate p1 = PredicateBuilderTest.header("name").isEqualTo((Object)Builder.constant((Object)"James"));
        Predicate p2 = PredicateBuilderTest.header("size").isGreaterThanOrEqualTo((Object)Builder.constant((Object)10));
        Predicate p3 = PredicateBuilderTest.header("location").contains((Object)Builder.constant((Object)"London"));
        Predicate and = PredicateBuilder.and((Predicate[])new Predicate[]{p1, p2, p3});
        this.assertMatches(and);
    }

    @Test
    public void testOrSignatures() {
        Predicate p1 = PredicateBuilderTest.header("name").isEqualTo((Object)Builder.constant((Object)"does-not-apply"));
        Predicate p2 = PredicateBuilderTest.header("size").isGreaterThanOrEqualTo((Object)Builder.constant((Object)10));
        Predicate p3 = PredicateBuilderTest.header("location").contains((Object)Builder.constant((Object)"does-not-apply"));
        this.assertMatches(PredicateBuilder.or((Predicate)p1, (Predicate)p2));
        this.assertMatches(PredicateBuilder.or((Predicate)p2, (Predicate)p3));
        this.assertMatches(PredicateBuilder.in((Predicate[])new Predicate[]{p1, p2, p3}));
        this.assertMatches(PredicateBuilder.or((Predicate[])new Predicate[]{p1, p2, p3}));
        this.assertMatches(PredicateBuilder.in(Arrays.asList(p1, p2, p3)));
        this.assertMatches(PredicateBuilder.or(Arrays.asList(p1, p2, p3)));
    }

    @Test
    public void testCompoundAndOrPredicates() {
        Predicate p1 = PredicateBuilderTest.header("name").isEqualTo((Object)Builder.constant((Object)"Hiram"));
        Predicate p2 = PredicateBuilderTest.header("size").isGreaterThan((Object)Builder.constant((Object)100));
        Predicate p3 = PredicateBuilderTest.header("location").contains((Object)"London");
        Predicate and = PredicateBuilder.and((Predicate)p1, (Predicate)p2);
        Predicate andor = PredicateBuilder.or((Predicate)and, (Predicate)p3);
        this.assertMatches(andor);
    }

    @Test
    public void testPredicateIn() {
        this.assertMatches(PredicateBuilder.in((Predicate[])new Predicate[]{PredicateBuilderTest.header("name").isEqualTo((Object)"Hiram"), PredicateBuilderTest.header("name").isEqualTo((Object)"James")}));
    }

    @Test
    public void testValueIn() {
        this.assertMatches(PredicateBuilderTest.header("name").in(new Object[]{"Hiram", "Jonathan", "James", "Claus"}));
    }

    @Test
    public void testEmptyHeaderValueIn() {
        this.assertDoesNotMatch(PredicateBuilderTest.header("xxx").in(new Object[]{"Hiram", "Jonathan", "James", "Claus"}));
    }

    @Test
    public void testStartsWith() {
        this.assertMatches(PredicateBuilderTest.header("name").startsWith((Object)"J"));
        this.assertMatches(PredicateBuilderTest.header("name").startsWith((Object)"James"));
        this.assertDoesNotMatch(PredicateBuilderTest.header("name").startsWith((Object)"C"));
        this.assertMatches(PredicateBuilderTest.header("size").startsWith((Object)"1"));
        this.assertMatches(PredicateBuilderTest.header("size").startsWith((Object)"10"));
        this.assertDoesNotMatch(PredicateBuilderTest.header("size").startsWith((Object)"99"));
        this.assertDoesNotMatch(PredicateBuilderTest.header("size").startsWith((Object)"9"));
        this.assertMatches(PredicateBuilderTest.header("size").startsWith((Object)1));
        this.assertMatches(PredicateBuilderTest.header("size").startsWith((Object)10));
        this.assertDoesNotMatch(PredicateBuilderTest.header("size").startsWith((Object)99));
        this.assertDoesNotMatch(PredicateBuilderTest.header("size").startsWith((Object)9));
    }

    @Test
    public void testEndsWith() {
        this.assertMatches(PredicateBuilderTest.header("name").endsWith((Object)"mes"));
        this.assertMatches(PredicateBuilderTest.header("name").endsWith((Object)"James"));
        this.assertDoesNotMatch(PredicateBuilderTest.header("name").endsWith((Object)"world"));
        this.assertMatches(PredicateBuilderTest.header("size").endsWith((Object)"0"));
        this.assertMatches(PredicateBuilderTest.header("size").endsWith((Object)"10"));
        this.assertDoesNotMatch(PredicateBuilderTest.header("size").endsWith((Object)"99"));
        this.assertDoesNotMatch(PredicateBuilderTest.header("size").endsWith((Object)"9"));
        this.assertMatches(PredicateBuilderTest.header("size").endsWith((Object)0));
        this.assertMatches(PredicateBuilderTest.header("size").endsWith((Object)10));
        this.assertDoesNotMatch(PredicateBuilderTest.header("size").endsWith((Object)99));
        this.assertDoesNotMatch(PredicateBuilderTest.header("size").endsWith((Object)9));
    }

    @Test
    public void testNot() {
        this.assertMatches(PredicateBuilderTest.body().not().isInstanceOf(Integer.class));
        this.assertMatches(PredicateBuilderTest.header("name").not().isEqualTo((Object)"Claus"));
        this.assertMatches(PredicateBuilderTest.header("size").not().isLessThan((Object)7));
        this.assertDoesNotMatch(PredicateBuilderTest.header("name").not().isEqualTo((Object)"James"));
    }

    @Test
    public void testMethod() {
        Animal tiger = new Animal("Tony", true);
        this.exchange.getMessage().setBody((Object)tiger);
        this.assertMatches(PredicateBuilder.isEqualTo((Expression)PredicateBuilderTest.bodyAs(Animal.class).method("getName"), (Expression)Builder.constant((Object)"Tony")));
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        Message in = this.exchange.getIn();
        in.setBody((Object)"Hello there!");
        in.setHeader("name", (Object)"James");
        in.setHeader("location", (Object)"Islington,London,UK");
        in.setHeader("size", (Object)10);
    }

    protected void assertMatches(Predicate predicate) {
        PredicateBuilderTest.assertPredicateMatches(predicate, this.exchange);
    }

    protected void assertDoesNotMatch(Predicate predicate) {
        PredicateBuilderTest.assertPredicateDoesNotMatch(predicate, this.exchange);
    }
}

