/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.support.DefaultExchange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PredicateBuilderConcurrentTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testPredicateBuilderConcurrent() throws Exception {
        int i;
        this.context.start();
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
        ExecutorService pool = Executors.newFixedThreadPool(10);
        for (i = 0; i < 1000; ++i) {
            final Integer num = i;
            Future<Boolean> future = pool.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    Expression left = ExpressionBuilder.headerExpression((String)"foo");
                    Expression right = num % 2 == 0 ? ExpressionBuilder.constantExpression((Object)"ABC") : ExpressionBuilder.constantExpression((Object)"DEF");
                    Predicate predicate = PredicateBuilder.isEqualTo((Expression)left, (Expression)right);
                    DefaultExchange exchange = new DefaultExchange((CamelContext)PredicateBuilderConcurrentTest.this.context);
                    exchange.getIn().setBody((Object)"Hello World");
                    exchange.getIn().setHeader("foo", (Object)"ABC");
                    return predicate.matches((Exchange)exchange);
                }
            });
            futures.add(future);
        }
        for (i = 0; i < 1000; ++i) {
            Boolean result = (Boolean)((Future)futures.get(i)).get(10L, TimeUnit.SECONDS);
            if (i % 2 == 0) {
                Assertions.assertTrue((boolean)result, (String)("Should be true for #" + i));
                continue;
            }
            Assertions.assertFalse((boolean)result, (String)("Should be false for #" + i));
        }
        pool.shutdownNow();
    }
}

