/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.support.DefaultExchange;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PredicateBinaryCoerceTypeTest
extends TestSupport {
    protected final Exchange exchange = new DefaultExchange((CamelContext)new DefaultCamelContext());

    @Test
    public void testIsNull() {
        Expression a = ExpressionBuilder.constantExpression((Object)"123");
        this.assertDoesNotMatch(PredicateBuilder.isNull((Expression)a));
        a = ExpressionBuilder.constantExpression(null);
        this.assertMatches(PredicateBuilder.isNull((Expression)a));
    }

    @Test
    public void testIsNotNull() {
        Expression a = ExpressionBuilder.constantExpression((Object)"123");
        this.assertMatches(PredicateBuilder.isNotNull((Expression)a));
        a = ExpressionBuilder.constantExpression(null);
        this.assertDoesNotMatch(PredicateBuilder.isNotNull((Expression)a));
    }

    @Test
    public void testEqual() {
        Expression a = ExpressionBuilder.constantExpression((Object)"123");
        Expression b = ExpressionBuilder.constantExpression((Object)Integer.valueOf("123"));
        this.assertMatches(PredicateBuilder.isEqualTo((Expression)a, (Expression)b));
        a = ExpressionBuilder.constantExpression((Object)Integer.valueOf("123"));
        b = ExpressionBuilder.constantExpression((Object)"123");
        this.assertMatches(PredicateBuilder.isEqualTo((Expression)a, (Expression)b));
    }

    @Test
    public void testEqualWithNull() {
        Expression a = ExpressionBuilder.constantExpression((Object)"123");
        Expression b = ExpressionBuilder.constantExpression(null);
        this.assertDoesNotMatch(PredicateBuilder.isEqualTo((Expression)a, (Expression)b));
        a = ExpressionBuilder.constantExpression(null);
        b = ExpressionBuilder.constantExpression((Object)"123");
        this.assertDoesNotMatch(PredicateBuilder.isEqualTo((Expression)a, (Expression)b));
        a = ExpressionBuilder.constantExpression(null);
        b = ExpressionBuilder.constantExpression(null);
        this.assertMatches(PredicateBuilder.isEqualTo((Expression)a, (Expression)b));
    }

    @Test
    public void testNotEqual() {
        Expression a = ExpressionBuilder.constantExpression((Object)"123");
        Expression b = ExpressionBuilder.constantExpression((Object)Integer.valueOf("123"));
        this.assertDoesNotMatch(PredicateBuilder.isNotEqualTo((Expression)a, (Expression)b));
        a = ExpressionBuilder.constantExpression((Object)"333");
        this.assertMatches(PredicateBuilder.isNotEqualTo((Expression)a, (Expression)b));
    }

    @Test
    public void testNotEqualWithNull() {
        Expression a = ExpressionBuilder.constantExpression((Object)"123");
        Expression b = ExpressionBuilder.constantExpression(null);
        this.assertMatches(PredicateBuilder.isNotEqualTo((Expression)a, (Expression)b));
        a = ExpressionBuilder.constantExpression(null);
        b = ExpressionBuilder.constantExpression((Object)"123");
        this.assertMatches(PredicateBuilder.isNotEqualTo((Expression)a, (Expression)b));
        a = ExpressionBuilder.constantExpression(null);
        b = ExpressionBuilder.constantExpression(null);
        this.assertDoesNotMatch(PredicateBuilder.isNotEqualTo((Expression)a, (Expression)b));
    }

    @Test
    public void testGreatherThan() {
        Expression a = ExpressionBuilder.constantExpression((Object)"200");
        Expression b = ExpressionBuilder.constantExpression((Object)Integer.valueOf("100"));
        this.assertMatches(PredicateBuilder.isGreaterThan((Expression)a, (Expression)b));
        this.assertDoesNotMatch(PredicateBuilder.isGreaterThan((Expression)b, (Expression)a));
        a = ExpressionBuilder.constantExpression((Object)Integer.valueOf("100"));
        b = ExpressionBuilder.constantExpression((Object)"200");
        this.assertDoesNotMatch(PredicateBuilder.isGreaterThan((Expression)a, (Expression)b));
        this.assertMatches(PredicateBuilder.isGreaterThan((Expression)b, (Expression)a));
    }

    @Test
    public void testGreatherThanOrEqual() {
        Expression a = ExpressionBuilder.constantExpression((Object)"200");
        Expression b = ExpressionBuilder.constantExpression((Object)Integer.valueOf("100"));
        this.assertMatches(PredicateBuilder.isGreaterThanOrEqualTo((Expression)a, (Expression)b));
        this.assertDoesNotMatch(PredicateBuilder.isGreaterThanOrEqualTo((Expression)b, (Expression)a));
        a = ExpressionBuilder.constantExpression((Object)Integer.valueOf("100"));
        b = ExpressionBuilder.constantExpression((Object)"200");
        this.assertDoesNotMatch(PredicateBuilder.isGreaterThanOrEqualTo((Expression)a, (Expression)b));
        this.assertMatches(PredicateBuilder.isGreaterThanOrEqualTo((Expression)b, (Expression)a));
        a = ExpressionBuilder.constantExpression((Object)"100");
        b = ExpressionBuilder.constantExpression((Object)Integer.valueOf("100"));
        this.assertMatches(PredicateBuilder.isGreaterThanOrEqualTo((Expression)a, (Expression)b));
        this.assertMatches(PredicateBuilder.isGreaterThanOrEqualTo((Expression)b, (Expression)a));
        a = ExpressionBuilder.constantExpression((Object)Integer.valueOf("100"));
        b = ExpressionBuilder.constantExpression((Object)"100");
        this.assertMatches(PredicateBuilder.isGreaterThanOrEqualTo((Expression)a, (Expression)b));
        this.assertMatches(PredicateBuilder.isGreaterThanOrEqualTo((Expression)b, (Expression)a));
    }

    @Test
    public void testLessThan() {
        Expression a = ExpressionBuilder.constantExpression((Object)"100");
        Expression b = ExpressionBuilder.constantExpression((Object)Integer.valueOf("200"));
        this.assertMatches(PredicateBuilder.isLessThan((Expression)a, (Expression)b));
        this.assertDoesNotMatch(PredicateBuilder.isLessThan((Expression)b, (Expression)a));
        a = ExpressionBuilder.constantExpression((Object)Integer.valueOf("100"));
        b = ExpressionBuilder.constantExpression((Object)"200");
        this.assertMatches(PredicateBuilder.isLessThan((Expression)a, (Expression)b));
        this.assertDoesNotMatch(PredicateBuilder.isLessThan((Expression)b, (Expression)a));
    }

    @Test
    public void testLessThanOrEqual() {
        Expression a = ExpressionBuilder.constantExpression((Object)"100");
        Expression b = ExpressionBuilder.constantExpression((Object)Integer.valueOf("200"));
        this.assertMatches(PredicateBuilder.isLessThanOrEqualTo((Expression)a, (Expression)b));
        this.assertDoesNotMatch(PredicateBuilder.isLessThanOrEqualTo((Expression)b, (Expression)a));
        a = ExpressionBuilder.constantExpression((Object)Integer.valueOf("200"));
        b = ExpressionBuilder.constantExpression((Object)"100");
        this.assertDoesNotMatch(PredicateBuilder.isLessThanOrEqualTo((Expression)a, (Expression)b));
        this.assertMatches(PredicateBuilder.isLessThanOrEqualTo((Expression)b, (Expression)a));
        a = ExpressionBuilder.constantExpression((Object)"100");
        b = ExpressionBuilder.constantExpression((Object)Integer.valueOf("100"));
        this.assertMatches(PredicateBuilder.isLessThanOrEqualTo((Expression)a, (Expression)b));
        this.assertMatches(PredicateBuilder.isLessThanOrEqualTo((Expression)b, (Expression)a));
        a = ExpressionBuilder.constantExpression((Object)Integer.valueOf("100"));
        b = ExpressionBuilder.constantExpression((Object)"100");
        this.assertMatches(PredicateBuilder.isGreaterThanOrEqualTo((Expression)a, (Expression)b));
        this.assertMatches(PredicateBuilder.isGreaterThanOrEqualTo((Expression)b, (Expression)a));
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        Message in = this.exchange.getIn();
        in.setBody((Object)"Hello there!");
        in.setHeader("name", (Object)"James");
        in.setHeader("location", (Object)"Islington,London,UK");
        in.setHeader("size", (Object)10);
    }

    protected void assertMatches(Predicate predicate) {
        PredicateBinaryCoerceTypeTest.assertPredicateMatches(predicate, this.exchange);
    }

    protected void assertDoesNotMatch(Predicate predicate) {
        PredicateBinaryCoerceTypeTest.assertPredicateDoesNotMatch(predicate, this.exchange);
    }
}

