/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NotifyBuilderWhenDoneByIndexTest
extends ContextTestSupport {
    @Test
    public void testDoneByIndex() {
        final AtomicInteger counter = new AtomicInteger();
        this.getMockEndpoint("mock:split").whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) {
                counter.incrementAndGet();
            }
        });
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDoneByIndex(0).create();
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("seda:foo", (Object)"A,B,C");
        Assertions.assertTrue((boolean)notify.matchesWaitTime());
        Assertions.assertEquals((int)3, (int)counter.get());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)this.from("seda:foo").routeId("foo").delay(500L).split((Expression)this.body().tokenize(",")).to("mock:split")).end().to("mock:foo");
            }
        };
    }
}

