/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.NotifyBuilderMatcher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NotifyBuilderTest
extends ContextTestSupport {
    @Test
    public void testMustBeCreated() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(1);
        Exception e = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> ((NotifyBuilder)notify).matches(), (String)"Should have thrown an exception");
        Assertions.assertEquals((Object)"NotifyBuilder has not been created. Invoke the create() method before matching.", (Object)e.getMessage());
    }

    @Test
    public void testDestroyUnregistersBuilder() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(1).create();
        int withReg = this.context.getManagementStrategy().getEventNotifiers().size();
        notify.destroy();
        int afterDestroy = this.context.getManagementStrategy().getEventNotifiers().size();
        Assertions.assertEquals((int)1, (int)(withReg - afterDestroy));
    }

    @Test
    public void testDestroyResetsBuilder() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(1).create();
        notify.destroy();
        Exception e = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> ((NotifyBuilder)notify).matches(), (String)"Should have thrown an exception");
        Assertions.assertEquals((Object)"NotifyBuilder has not been created. Invoke the create() method before matching.", (Object)e.getMessage());
    }

    @Test
    public void testDestroyedBuilderCannotBeRecreated() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(1).create();
        notify.destroy();
        Exception e = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> ((NotifyBuilder)notify).create(), (String)"Should have thrown an exception");
        Assertions.assertEquals((Object)"A destroyed NotifyBuilder cannot be re-created.", (Object)e.getMessage());
    }

    @Test
    public void testDirectWhenExchangeDoneSimple() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).from("direct:foo").whenDone(1).create();
        Assertions.assertEquals((Object)"from(direct:foo).whenDone(1)", (Object)notify.toString());
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"A");
        Assertions.assertTrue((boolean)notify.matches());
    }

    @Test
    public void testDirectBeerWhenExchangeDoneSimple() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).from("direct:beer").whenDone(1).create();
        Assertions.assertEquals((Object)"from(direct:beer).whenDone(1)", (Object)notify.toString());
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:beer", (Object)"A");
        Assertions.assertTrue((boolean)notify.matches());
    }

    @Test
    public void testDirectFromRoute() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).fromRoute("foo").whenDone(1).create();
        Assertions.assertEquals((Object)"fromRoute(foo).whenDone(1)", (Object)notify.toString());
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"A");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"B");
        Assertions.assertTrue((boolean)notify.matches());
    }

    @Test
    public void testDirectFromRouteReceived() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).fromRoute("foo").whenReceived(1).create();
        Assertions.assertEquals((Object)"fromRoute(foo).whenReceived(1)", (Object)notify.toString());
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"A");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"B");
        Assertions.assertTrue((boolean)notify.matches());
    }

    @Test
    public void testWhenExchangeDone() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).from("direct:foo").whenDone(5).create();
        Assertions.assertEquals((Object)"from(direct:foo).whenDone(5)", (Object)notify.toString());
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"A");
        this.template.sendBody("direct:foo", (Object)"B");
        this.template.sendBody("direct:foo", (Object)"C");
        this.template.sendBody("direct:bar", (Object)"D");
        this.template.sendBody("direct:bar", (Object)"E");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"F");
        this.template.sendBody("direct:bar", (Object)"G");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"H");
        this.template.sendBody("direct:bar", (Object)"I");
        Assertions.assertTrue((boolean)notify.matches());
    }

    @Test
    public void testWhenExchangeDoneAnd() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).from("direct:foo").whenDone(5).and().from("direct:bar").whenDone(7).create();
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"A");
        this.template.sendBody("direct:foo", (Object)"B");
        this.template.sendBody("direct:foo", (Object)"C");
        this.template.sendBody("direct:bar", (Object)"D");
        this.template.sendBody("direct:bar", (Object)"E");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"F");
        this.template.sendBody("direct:bar", (Object)"G");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"H");
        this.template.sendBody("direct:bar", (Object)"I");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"J");
        this.template.sendBody("direct:bar", (Object)"K");
        this.template.sendBody("direct:bar", (Object)"L");
        Assertions.assertTrue((boolean)notify.matches());
    }

    @Test
    public void testFromRouteWhenExchangeDoneAnd() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).fromRoute("foo").whenDone(5).and().fromRoute("bar").whenDone(7).create();
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"A");
        this.template.sendBody("direct:foo", (Object)"B");
        this.template.sendBody("direct:foo", (Object)"C");
        this.template.sendBody("direct:bar", (Object)"D");
        this.template.sendBody("direct:bar", (Object)"E");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"F");
        this.template.sendBody("direct:bar", (Object)"G");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"H");
        this.template.sendBody("direct:bar", (Object)"I");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"J");
        this.template.sendBody("direct:bar", (Object)"K");
        this.template.sendBody("direct:bar", (Object)"L");
        Assertions.assertTrue((boolean)notify.matches());
    }

    @Test
    public void testFromRouteAndNot() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).fromRoute("foo").whenDone(2).and().fromRoute("bar").whenReceived(1).not().fromRoute("cake").whenDone(1).create();
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"A");
        this.template.sendBody("direct:foo", (Object)"B");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"C");
        Assertions.assertTrue((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"D");
        this.template.sendBody("direct:bar", (Object)"E");
        Assertions.assertTrue((boolean)notify.matches());
        this.template.sendBody("direct:cake", (Object)"F");
        Assertions.assertFalse((boolean)notify.matches());
    }

    @Test
    public void testWhenExchangeDoneOr() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).from("direct:foo").whenDone(5).or().from("direct:bar").whenDone(7).create();
        Assertions.assertEquals((Object)"from(direct:foo).whenDone(5).or().from(direct:bar).whenDone(7)", (Object)notify.toString());
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"A");
        this.template.sendBody("direct:foo", (Object)"B");
        this.template.sendBody("direct:foo", (Object)"C");
        this.template.sendBody("direct:bar", (Object)"D");
        this.template.sendBody("direct:bar", (Object)"E");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"G");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"I");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"J");
        this.template.sendBody("direct:bar", (Object)"K");
        this.template.sendBody("direct:bar", (Object)"L");
        Assertions.assertTrue((boolean)notify.matches());
    }

    @Test
    public void testWhenExchangeDoneNot() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).from("direct:foo").whenDone(5).not().from("direct:bar").whenDone(1).create();
        Assertions.assertEquals((Object)"from(direct:foo).whenDone(5).not().from(direct:bar).whenDone(1)", (Object)notify.toString());
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"A");
        this.template.sendBody("direct:foo", (Object)"B");
        this.template.sendBody("direct:foo", (Object)"C");
        this.template.sendBody("direct:foo", (Object)"D");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"E");
        Assertions.assertTrue((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"F");
        Assertions.assertTrue((boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"G");
        Assertions.assertFalse((boolean)notify.matches());
    }

    @Test
    public void testWhenExchangeDoneOrFailure() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(5).or().whenFailed(1).create();
        Assertions.assertEquals((Object)"whenDone(5).or().whenFailed(1)", (Object)notify.toString());
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"A");
        this.template.sendBody("direct:foo", (Object)"B");
        this.template.sendBody("direct:foo", (Object)"D");
        Assertions.assertFalse((boolean)notify.matches());
        Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:fail", (Object)"E"), (String)"Should have thrown exception");
        Assertions.assertTrue((boolean)notify.matches());
    }

    @Test
    public void testWhenExchangeDoneNotFailure() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(5).not().whenFailed(1).create();
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"A");
        this.template.sendBody("direct:foo", (Object)"B");
        this.template.sendBody("direct:foo", (Object)"D");
        this.template.sendBody("direct:bar", (Object)"E");
        this.template.sendBody("direct:bar", (Object)"F");
        Assertions.assertTrue((boolean)notify.matches());
        Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:fail", (Object)"G"), (String)"Should have thrown exception");
        Assertions.assertFalse((boolean)notify.matches());
    }

    @Test
    public void testFilterWhenExchangeDone() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).filter(NotifyBuilderTest.body().contains((Object)"World")).whenDone(3).create();
        Assertions.assertEquals((Object)"filter(body contains World).whenDone(3)", (Object)notify.toString());
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.template.sendBody("direct:foo", (Object)"Hi World");
        this.template.sendBody("direct:foo", (Object)"A");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"B");
        this.template.sendBody("direct:bar", (Object)"C");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"Bye World");
        Assertions.assertTrue((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"D");
        this.template.sendBody("direct:bar", (Object)"Hey World");
        Assertions.assertTrue((boolean)notify.matches());
    }

    @Test
    public void testFromFilterWhenExchangeDone() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).from("direct:foo").filter(NotifyBuilderTest.body().contains((Object)"World")).whenDone(3).create();
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.template.sendBody("direct:foo", (Object)"Hi World");
        this.template.sendBody("direct:foo", (Object)"A");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"B");
        this.template.sendBody("direct:foo", (Object)"C");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"Bye World");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"D");
        this.template.sendBody("direct:foo", (Object)"Hey World");
        Assertions.assertTrue((boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"E");
        this.template.sendBody("direct:foo", (Object)"Hi Again World");
        Assertions.assertTrue((boolean)notify.matches());
    }

    @Test
    public void testFromFilterBuilderWhenExchangeDone() {
        NotifyBuilder notify = ((NotifyBuilder)new NotifyBuilder((CamelContext)this.context).filter().xpath("/person[@name='James']")).whenDone(1).create();
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"<person name='Claus'/>");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"<person name='Jonathan'/>");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"<person name='James'/>");
        Assertions.assertTrue((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"<person name='Hadrian'/>");
        Assertions.assertTrue((boolean)notify.matches());
    }

    @Test
    public void testWhenExchangeCompleted() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenCompleted(5).create();
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"A");
        this.template.sendBody("direct:foo", (Object)"B");
        this.template.sendBody("direct:bar", (Object)"C");
        Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:fail", (Object)"D"), (String)"Should have thrown exception");
        Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:fail", (Object)"E"), (String)"Should have thrown exception");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"F");
        this.template.sendBody("direct:foo", (Object)"G");
        this.template.sendBody("direct:bar", (Object)"H");
        Assertions.assertTrue((boolean)notify.matches());
    }

    @Test
    public void testWhenExchangeExactlyDone() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenExactlyDone(5).create();
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"A");
        this.template.sendBody("direct:foo", (Object)"B");
        this.template.sendBody("direct:foo", (Object)"C");
        this.template.sendBody("direct:bar", (Object)"D");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"E");
        Assertions.assertTrue((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"F");
        Assertions.assertFalse((boolean)notify.matches());
    }

    @Test
    public void testWhenExchangeExactlyComplete() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenExactlyCompleted(5).create();
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"A");
        this.template.sendBody("direct:foo", (Object)"B");
        this.template.sendBody("direct:foo", (Object)"C");
        this.template.sendBody("direct:bar", (Object)"D");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"E");
        Assertions.assertTrue((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"F");
        Assertions.assertFalse((boolean)notify.matches());
    }

    @Test
    public void testWhenExchangeExactlyFailed() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenExactlyFailed(2).create();
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"A");
        this.template.sendBody("direct:foo", (Object)"B");
        this.template.sendBody("direct:foo", (Object)"C");
        Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:fail", (Object)"D"), (String)"Should have thrown exception");
        this.template.sendBody("direct:bar", (Object)"E");
        Assertions.assertFalse((boolean)notify.matches());
        Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:fail", (Object)"F"), (String)"Should have thrown exception");
        Assertions.assertTrue((boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"G");
        Assertions.assertTrue((boolean)notify.matches());
        Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:fail", (Object)"H"), (String)"Should have thrown exception");
        Assertions.assertFalse((boolean)notify.matches());
    }

    @Test
    public void testWhenAnyReceivedMatches() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenAnyReceivedMatches(NotifyBuilderTest.body().contains((Object)"Camel")).create();
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hello World");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Bye World");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"Hello Camel");
        Assertions.assertTrue((boolean)notify.matches());
    }

    @Test
    public void testWhenAllReceivedMatches() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenAllReceivedMatches(NotifyBuilderTest.body().contains((Object)"Camel")).create();
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hello Camel");
        Assertions.assertTrue((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Bye Camel");
        Assertions.assertTrue((boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"Hello World");
        Assertions.assertFalse((boolean)notify.matches());
    }

    @Test
    public void testWhenAnyDoneMatches() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenAnyDoneMatches(NotifyBuilderTest.body().contains((Object)"Bye")).create();
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hi World");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:cake", (Object)"Camel");
        Assertions.assertTrue((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Damn World");
        Assertions.assertTrue((boolean)notify.matches());
    }

    @Test
    public void testWhenAllDoneMatches() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenAllDoneMatches(NotifyBuilderTest.body().contains((Object)"Bye")).create();
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:cake", (Object)"Camel");
        Assertions.assertTrue((boolean)notify.matches());
        this.template.sendBody("direct:cake", (Object)"World");
        Assertions.assertTrue((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hi World");
        Assertions.assertFalse((boolean)notify.matches());
    }

    @Test
    public void testWhenBodiesReceived() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenBodiesReceived(new Object[]{"Hi World", "Hello World"}).create();
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hi World");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hello World");
        Assertions.assertTrue((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Bye World");
        Assertions.assertTrue((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Damn World");
        Assertions.assertTrue((boolean)notify.matches());
    }

    @Test
    public void testWhenBodiesDone() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenBodiesDone(new Object[]{"Bye World", "Bye Camel"}).create();
        Assertions.assertFalse((boolean)notify.matches());
        this.template.requestBody("direct:cake", (Object)"World");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:cake", (Object)"Camel");
        Assertions.assertTrue((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Damn World");
        Assertions.assertTrue((boolean)notify.matches());
    }

    @Test
    public void testWhenExactBodiesReceived() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenExactBodiesReceived(new Object[]{"Hi World", "Hello World"}).create();
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hi World");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hello World");
        Assertions.assertTrue((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Bye World");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Damn World");
        Assertions.assertFalse((boolean)notify.matches());
    }

    @Test
    public void testWhenExactBodiesDone() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenExactBodiesDone(new Object[]{"Bye World", "Bye Camel"}).create();
        Assertions.assertFalse((boolean)notify.matches());
        this.template.requestBody("direct:cake", (Object)"World");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:cake", (Object)"Camel");
        Assertions.assertTrue((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Damn World");
        Assertions.assertFalse((boolean)notify.matches());
    }

    @Test
    public void testWhenReceivedSatisfied() {
        MockEndpoint mock = this.getMockEndpoint("mock:assert");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World", "Bye World", "Hi World"});
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).from("direct:foo").whenDoneSatisfied((NotifyBuilderMatcher)mock).create();
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Bye World");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hello World");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"Hi World");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hi World");
        Assertions.assertTrue((boolean)notify.matches());
    }

    @Test
    public void testWhenReceivedSatisfiedFalse() {
        MockEndpoint mock = this.getMockEndpoint("mock:assert");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World", "Bye World", "Does not happen", "Hi World"});
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).from("direct:foo").whenDoneSatisfied((NotifyBuilderMatcher)mock).create();
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Bye World");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hello World");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"Hi World");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hi World");
        Assertions.assertFalse((boolean)notify.matches());
    }

    @Test
    public void testWhenReceivedNotSatisfied() {
        MockEndpoint mock = this.getMockEndpoint("mock:assert");
        mock.expectedMessageCount(2);
        ((MockValueBuilder)mock.message(1).body()).contains((Object)"Camel");
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).from("direct:foo").whenReceivedNotSatisfied((NotifyBuilderMatcher)mock).create();
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Bye World");
        Assertions.assertTrue((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hello Camel");
        Assertions.assertFalse((boolean)notify.matches());
    }

    @Test
    public void testWhenNotSatisfiedUsingSatisfied() {
        MockEndpoint mock = this.getMockEndpoint("mock:assert");
        mock.expectedMessageCount(2);
        ((MockValueBuilder)mock.message(1).body()).contains((Object)"Camel");
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).from("direct:foo").whenReceivedSatisfied((NotifyBuilderMatcher)mock).create();
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Bye World");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hello Camel");
        Assertions.assertTrue((boolean)notify.matches());
    }

    @Test
    public void testComplexOrCamel() {
        MockEndpoint mock = this.getMockEndpoint("mock:assert");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World", "Bye World", "Hi World"});
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).from("direct:foo").whenReceivedSatisfied((NotifyBuilderMatcher)mock).and().from("direct:bar").whenExactlyDone(5).whenAnyReceivedMatches(NotifyBuilderTest.body().contains((Object)"Camel")).create();
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Bye World");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hello World");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"Hi World");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hi World");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"Hi Camel");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"A");
        this.template.sendBody("direct:bar", (Object)"B");
        this.template.sendBody("direct:bar", (Object)"C");
        Assertions.assertTrue((boolean)notify.matches());
    }

    @Test
    public void testWhenDoneSatisfied() {
        MockEndpoint mock = this.getMockEndpoint("mock:assert");
        mock.expectedBodiesReceived(new Object[]{"Bye World", "Bye Camel"});
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDoneSatisfied((NotifyBuilderMatcher)mock).create();
        Assertions.assertFalse((boolean)notify.matches());
        this.template.requestBody("direct:cake", (Object)"World");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.requestBody("direct:cake", (Object)"Camel");
        Assertions.assertTrue((boolean)notify.matches());
        this.template.requestBody("direct:cake", (Object)"Damn");
        Assertions.assertTrue((boolean)notify.matches());
    }

    @Test
    public void testWhenDoneNotSatisfied() {
        MockEndpoint mock = this.getMockEndpoint("mock:assert");
        mock.expectedBodiesReceived(new Object[]{"Bye World", "Bye Camel"});
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDoneNotSatisfied((NotifyBuilderMatcher)mock).create();
        Assertions.assertFalse((boolean)notify.matches());
        this.template.requestBody("direct:cake", (Object)"World");
        Assertions.assertTrue((boolean)notify.matches());
        this.template.requestBody("direct:cake", (Object)"Camel");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.requestBody("direct:cake", (Object)"Damn");
        Assertions.assertFalse((boolean)notify.matches());
    }

    @Test
    public void testReset() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenExactlyDone(1).create();
        this.template.sendBody("direct:foo", (Object)"Hello World");
        Assertions.assertTrue((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Bye World");
        Assertions.assertFalse((boolean)notify.matches());
        notify.reset();
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hello World");
        Assertions.assertTrue((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Bye World");
        Assertions.assertFalse((boolean)notify.matches());
    }

    @Test
    public void testResetBodiesReceived() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenBodiesReceived(new Object[]{"Hello World", "Bye World"}).create();
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.template.sendBody("direct:foo", (Object)"Bye World");
        Assertions.assertTrue((boolean)notify.matches());
        notify.reset();
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hello World");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Bye World");
        Assertions.assertTrue((boolean)notify.matches());
    }

    @Test
    public void testOneNonAbstractPredicate() {
        Exception e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> new NotifyBuilder((CamelContext)this.context).wereSentTo("mock:foo").create(), (String)"Should throw exception");
        Assertions.assertEquals((Object)"NotifyBuilder must contain at least one non-abstract predicate (such as whenDone)", (Object)e.getMessage());
    }

    @Test
    public void testWereSentTo() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).wereSentTo("mock:foo").whenDone(1).create();
        this.template.sendBody("direct:bar", (Object)"Hello World");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Bye World");
        Assertions.assertTrue((boolean)notify.matches());
    }

    @Test
    public void testTwoWereSentTo() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).wereSentTo("log:beer").wereSentTo("mock:beer").whenDone(1).create();
        this.template.sendBody("direct:bar", (Object)"Hello World");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:beer", (Object)"Bye World");
        Assertions.assertTrue((boolean)notify.matches());
    }

    @Test
    public void testWhenDoneWereSentTo() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(2).wereSentTo("mock:beer").create();
        this.template.sendBody("direct:bar", (Object)"A");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:beer", (Object)"B");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"C");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"D");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:cake", (Object)"E");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:beer", (Object)"F");
        Assertions.assertTrue((boolean)notify.matches());
    }

    @Test
    public void testWereSentToWhenDone() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).wereSentTo("mock:beer").whenDone(2).create();
        this.template.sendBody("direct:bar", (Object)"A");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:beer", (Object)"B");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"C");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"D");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:cake", (Object)"E");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:beer", (Object)"F");
        Assertions.assertTrue((boolean)notify.matches());
    }

    @Test
    public void testTwoWereSentToRegExp() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).wereSentTo(".*beer.*").whenDone(1).create();
        this.template.sendBody("direct:bar", (Object)"Hello World");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:beer", (Object)"Bye World");
        Assertions.assertTrue((boolean)notify.matches());
    }

    @Test
    public void testTwoWereSentToDoneAndFailed() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(2).wereSentTo("mock:bar").and().whenFailed(1).wereSentTo("mock:fail").create();
        this.template.sendBody("direct:bar", (Object)"Hello World");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:bar", (Object)"Hello World");
        Assertions.assertFalse((boolean)notify.matches());
        this.template.sendBody("direct:foo", (Object)"Hello World");
        Assertions.assertFalse((boolean)notify.matches());
        Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("direct:fail", (Object)"Bye World"), (String)"Should have thrown exception");
        Assertions.assertTrue((boolean)notify.matches());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:foo").routeId("foo").to("mock:foo");
                ((RouteDefinition)this.from("direct:bar").routeId("bar").to("log:bar")).to("mock:bar");
                ((RouteDefinition)this.from("direct:fail").routeId("fail").to("mock:fail")).throwException((Exception)new IllegalArgumentException("Damn"));
                ((RouteDefinition)this.from("direct:cake").routeId("cake").transform((Expression)this.body().prepend((Object)"Bye "))).to("log:cake");
                ((RouteDefinition)this.from("direct:beer").routeId("beer").to("log:beer")).to("mock:beer");
            }
        };
    }
}

