/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.DefaultEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NotifyBuilderFromRouteTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry registry = super.createCamelRegistry();
        registry.bind("proxy", (Object)new ProxyComponent());
        return registry;
    }

    @Test
    public void testDoneFromRoute() {
        NotifyBuilder builder = new NotifyBuilder((CamelContext)this.context).fromRoute("foo").whenDone(1);
        builder.create();
        this.template.sendBody("seda:foo", (Object)"Hello world!");
        Assertions.assertTrue((boolean)builder.matchesWaitTime());
    }

    @Test
    public void testDoneFromCurrentRoute() {
        NotifyBuilder builder = new NotifyBuilder((CamelContext)this.context).fromCurrentRoute("bar").whenDone(1);
        builder.create();
        this.template.sendBody("seda:foo", (Object)"Hello world!");
        Assertions.assertTrue((boolean)builder.matchesWaitTime());
    }

    @Test
    public void testDoneFromCurrentRouteStartRoute() {
        NotifyBuilder builder = new NotifyBuilder((CamelContext)this.context).fromCurrentRoute("foo").whenDone(1);
        builder.create();
        this.template.sendBody("seda:foo", (Object)"Hello world!");
        Assertions.assertTrue((boolean)builder.matchesWaitTime());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("proxy:seda:foo").routeId("foo").to("direct:bar")).to("mock:foo");
                this.from("direct:bar").routeId("bar").to("mock:bar");
            }
        };
    }

    private static final class ProxyComponent
    extends DefaultComponent {
        private ProxyComponent() {
        }

        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) {
            return new ProxyEndpoint(this, uri, remaining);
        }
    }

    private static final class ProxyEndpoint
    extends DefaultEndpoint {
        private final Endpoint target;

        private ProxyEndpoint(ProxyComponent component, String uri, String target) {
            super(uri, (Component)component);
            this.target = this.getCamelContext().getEndpoint(target);
        }

        public Producer createProducer() throws Exception {
            return this.target.createProducer();
        }

        public Consumer createConsumer(Processor processor) throws Exception {
            return this.target.createConsumer(processor);
        }

        public boolean isSingleton() {
            return this.target.isSingleton();
        }
    }
}

