/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.concurrent.Future;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.ExchangeBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.impl.engine.DefaultFluentProducerTemplate;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FluentProducerTemplateTest
extends ContextTestSupport {
    @Test
    public void testNoEndpoint() {
        FluentProducerTemplate fluent = this.context.createFluentProducerTemplate();
        FluentProducerTemplate helloWorld = fluent.withBody((Object)"Hello World");
        Assertions.assertThrows(IllegalArgumentException.class, () -> helloWorld.send(), (String)"Should have thrown exception");
        Assertions.assertThrows(IllegalArgumentException.class, () -> helloWorld.request(), (String)"Should have thrown exception");
    }

    @Test
    public void testDefaultEndpoint() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        FluentProducerTemplate fluent = this.context.createFluentProducerTemplate();
        fluent.setDefaultEndpointUri("direct:in");
        Object result = fluent.withBody((Object)"Hello World").request();
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)"Bye World", (Object)result);
        Assertions.assertSame((Object)this.context, (Object)fluent.getCamelContext());
    }

    @Test
    public void testFromCamelContext() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        FluentProducerTemplate fluent = this.context.createFluentProducerTemplate();
        Object result = fluent.withBody((Object)"Hello World").to("direct:in").request();
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)"Bye World", (Object)result);
        Assertions.assertSame((Object)this.context, (Object)fluent.getCamelContext());
    }

    @Test
    public void testToF() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        FluentProducerTemplate on = DefaultFluentProducerTemplate.on((CamelContext)this.context);
        Object result = on.withBody((Object)"Hello World").toF("direct:%s", new Object[]{"in"}).request();
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)"Bye World", (Object)result);
        Assertions.assertSame((Object)this.context, (Object)this.template.getCamelContext());
    }

    @Test
    public void testWithDefaultEndpoint() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        FluentProducerTemplate template = DefaultFluentProducerTemplate.on((CamelContext)this.context, (String)"direct:in");
        Object result = template.withBody((Object)"Hello World").request();
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)"Bye World", (Object)result);
        Assertions.assertSame((Object)this.context, (Object)template.getCamelContext());
    }

    @Test
    public void testIn() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        Object result = DefaultFluentProducerTemplate.on((CamelContext)this.context).withBody((Object)"Hello World").to("direct:in").request();
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)"Bye World", (Object)result);
        Assertions.assertSame((Object)this.context, (Object)this.template.getCamelContext());
    }

    @Test
    public void testInTwice() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World", "Bye World"});
        FluentProducerTemplate template = DefaultFluentProducerTemplate.on((CamelContext)this.context);
        Object result = template.withBody((Object)"Hello World").to("direct:in").request();
        Object result2 = template.withBody((Object)"Hello World Again").to("direct:in").request();
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)"Bye World", (Object)result);
        Assertions.assertEquals((Object)"Bye World", (Object)result2);
        Assertions.assertSame((Object)this.context, (Object)template.getCamelContext());
    }

    @Test
    public void testInOut() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye Bye World"});
        Object result = DefaultFluentProducerTemplate.on((CamelContext)this.context).withBody((Object)"Hello World").to("direct:out").request();
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)"Bye Bye World", (Object)result);
    }

    @Test
    public void testInOutWithBodyConversion() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{11});
        Object result = DefaultFluentProducerTemplate.on((CamelContext)this.context).withBodyAs((Object)"10", Integer.class).to("direct:sum").request();
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)11, (Object)result);
    }

    @Test
    public void testInOutWithBodyConversionFault() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        try {
            DefaultFluentProducerTemplate.on((CamelContext)this.context).withBodyAs((Object)"10", Double.class).to("direct:sum").request();
        }
        catch (CamelExecutionException e) {
            boolean b = e.getCause() instanceof IllegalArgumentException;
            Assertions.assertTrue((boolean)b);
            Assertions.assertEquals((Object)"Expected body of type Integer", (Object)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testExceptionUsingBody() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        Exchange out = DefaultFluentProducerTemplate.on((CamelContext)this.context).withBody((Object)"Hello World").to("direct:exception").send();
        Assertions.assertTrue((boolean)out.isFailed());
        boolean b = out.getException() instanceof IllegalArgumentException;
        Assertions.assertTrue((boolean)b);
        Assertions.assertEquals((Object)"Forced exception by unit test", (Object)out.getException().getMessage());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testExceptionUsingProcessor() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        Exchange out = DefaultFluentProducerTemplate.on((CamelContext)this.context).withProcessor(exchange -> exchange.getIn().setBody((Object)"Hello World")).to("direct:exception").send();
        Assertions.assertTrue((boolean)out.isFailed());
        Assertions.assertEquals((Object)"Forced exception by unit test", (Object)out.getException().getMessage());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testExceptionUsingExchange() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        Exchange out = DefaultFluentProducerTemplate.on((CamelContext)this.context).withExchange(() -> {
            Exchange exchange = this.context.getEndpoint("direct:exception").createExchange();
            exchange.getIn().setBody((Object)"Hello World");
            return exchange;
        }).to("direct:exception").send();
        Assertions.assertTrue((boolean)out.isFailed());
        Assertions.assertEquals((Object)"Forced exception by unit test", (Object)out.getException().getMessage());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testExceptionUsingProcessorAndBody() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DefaultFluentProducerTemplate.on((CamelContext)this.context).withBody((Object)"World").withProcessor(exchange -> exchange.getIn().setHeader("foo", (Object)123)).to("direct:async").send(), (String)"");
    }

    @Test
    public void testRequestExceptionUsingBody() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        try {
            DefaultFluentProducerTemplate.on((CamelContext)this.context).withBody((Object)"Hello World").to("direct:exception").request();
            Assertions.fail((String)"Should have thrown RuntimeCamelException");
        }
        catch (RuntimeCamelException e) {
            boolean b = e.getCause() instanceof IllegalArgumentException;
            Assertions.assertTrue((boolean)b);
            Assertions.assertEquals((Object)"Forced exception by unit test", (Object)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRequestExceptionUsingProcessor() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        Exchange out = (Exchange)DefaultFluentProducerTemplate.on((CamelContext)this.context).withProcessor(exchange -> exchange.getIn().setBody((Object)"Hello World")).to("direct:exception").request(Exchange.class);
        Assertions.assertTrue((boolean)out.isFailed());
        Assertions.assertEquals((Object)"Forced exception by unit test", (Object)out.getException().getMessage());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRequestExceptionUsingExchange() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        Exchange out = DefaultFluentProducerTemplate.on((CamelContext)this.context).withExchange(() -> {
            Exchange exchange = this.context.getEndpoint("direct:exception").createExchange(ExchangePattern.InOut);
            exchange.getIn().setBody((Object)"Hello World");
            return exchange;
        }).to("direct:exception").send();
        Assertions.assertTrue((boolean)out.isFailed());
        Assertions.assertEquals((Object)"Forced exception by unit test", (Object)out.getException().getMessage());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testWithExchange() {
        Exchange exchange = ExchangeBuilder.anExchange((CamelContext)this.context).withBody((Object)"Hello!").withPattern(ExchangePattern.InOut).build();
        exchange = this.context.createFluentProducerTemplate().withExchange(exchange).to("direct:in").send();
        Assertions.assertEquals((Object)"Bye World", (Object)exchange.getMessage().getBody());
        String str = "withExchange not supported on FluentProducerTemplate.request method. Use send method instead.";
        Exchange finalExchange = exchange;
        Exception e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> this.context.createFluentProducerTemplate().withExchange(finalExchange).to("direct:in").request(String.class), (String)"Should throw exception");
        Assertions.assertEquals((Object)str, (Object)e.getMessage());
    }

    @Test
    public void testRequestBody() {
        FluentProducerTemplate template = DefaultFluentProducerTemplate.on((CamelContext)this.context);
        Integer expectedResult = 123;
        Assertions.assertEquals((Integer)expectedResult, (Integer)((Integer)template.withBody((Object)"Hello").to("direct:inout").request(Integer.class)));
        Assertions.assertEquals((Integer)expectedResult, (Integer)((Integer)template.withHeader("foo", (Object)"bar").withBody((Object)"Hello").to("direct:inout").request(Integer.class)));
        Assertions.assertEquals((Integer)expectedResult, (Integer)((Integer)template.withBody((Object)"Hello").to("direct:inout").request(Integer.class)));
        Assertions.assertEquals((Integer)expectedResult, (Integer)((Integer)template.withBody((Object)"Hello").to(this.context.getEndpoint("direct:inout")).request(Integer.class)));
        Assertions.assertEquals((Integer)expectedResult, (Integer)((Integer)template.withHeader("foo", (Object)"bar").withBody((Object)"Hello").to(this.context.getEndpoint("direct:inout")).request(Integer.class)));
        Assertions.assertEquals((Integer)expectedResult, (Integer)((Integer)template.withBody((Object)"Hello").to(this.context.getEndpoint("direct:inout")).request(Integer.class)));
    }

    @Test
    public void testWithVariable() {
        FluentProducerTemplate template = DefaultFluentProducerTemplate.on((CamelContext)this.context);
        Assertions.assertEquals((Object)"Hello World", (Object)template.withVariable("foo", (Object)"World").withBody((Object)"Hello").to("direct:var").request(String.class));
        Assertions.assertEquals((Object)"Hello Moon", (Object)template.withVariable("foo", (Object)"Moon").withVariable("global:planet", (Object)"Mars").withBody((Object)"Hello").to("direct:var").request(String.class));
        Assertions.assertEquals((Object)"Mars", (Object)this.context.getVariable("planet"));
    }

    @Test
    public void testWithExchangeProperty() {
        FluentProducerTemplate template = DefaultFluentProducerTemplate.on((CamelContext)this.context);
        Assertions.assertEquals((Object)"Hello World", (Object)template.withExchangeProperty("foo", (Object)"World").withBody((Object)"Hello").to("direct:ep").request(String.class));
        Assertions.assertEquals((Object)"Hello Moon", (Object)template.withExchangeProperty("foo", (Object)"Moon").withExchangeProperty("planet", (Object)"Mars").withBody((Object)"Hello").to("direct:ep").request(String.class));
    }

    @Test
    public void testAsyncRequest() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:async");
        mock.expectedMessageCount(2);
        mock.expectedHeaderValuesReceivedInAnyOrder("action", new Object[]{"action-1", "action-2"});
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"body-1", "body-2"});
        FluentProducerTemplate fluent = this.context.createFluentProducerTemplate();
        Future future1 = fluent.to("direct:async").withHeader("action", (Object)"action-1").withBody((Object)"body-1").asyncRequest(String.class);
        Future future2 = fluent.to("direct:async").withHeader("action", (Object)"action-2").withBody((Object)"body-2").asyncRequest(String.class);
        String result1 = (String)future1.get();
        String result2 = (String)future2.get();
        mock.assertIsSatisfied();
        Assertions.assertEquals((Object)"body-1", (Object)result1);
        Assertions.assertEquals((Object)"body-2", (Object)result2);
        String action = (String)((Exchange)mock.getExchanges().get(0)).getIn().getHeader("action", String.class);
        if (action.equals("action-1")) {
            Assertions.assertEquals((Object)"body-1", (Object)((Exchange)mock.getExchanges().get(0)).getIn().getBody(String.class));
        }
        if (action.equals("action-2")) {
            Assertions.assertEquals((Object)"body-2", (Object)((Exchange)mock.getExchanges().get(0)).getIn().getBody(String.class));
        }
    }

    @Test
    public void testAsyncSend() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:async");
        mock.expectedMessageCount(2);
        FluentProducerTemplate fluent = this.context.createFluentProducerTemplate();
        Future future1 = fluent.to("direct:async").withHeader("action", (Object)"action-1").withBody((Object)"body-1").asyncSend();
        Future future2 = fluent.to("direct:async").withHeader("action", (Object)"action-2").withBody((Object)"body-2").asyncSend();
        Exchange exchange1 = (Exchange)future1.get();
        Exchange exchange2 = (Exchange)future2.get();
        Assertions.assertEquals((Object)"action-1", (Object)exchange1.getIn().getHeader("action", String.class));
        Assertions.assertEquals((Object)"body-1", (Object)exchange1.getIn().getBody(String.class));
        Assertions.assertEquals((Object)"action-2", (Object)exchange2.getIn().getHeader("action", String.class));
        Assertions.assertEquals((Object)"body-2", (Object)exchange2.getIn().getBody(String.class));
    }

    @Test
    public void testWithCustomizer() throws Exception {
        this.getMockEndpoint("mock:custom").expectedBodiesReceived(new Object[]{"Hello World"});
        FluentProducerTemplate fluent = this.context.createFluentProducerTemplate().withTemplateCustomizer(t -> t.setDefaultEndpointUri("mock:custom"));
        fluent.withBody((Object)"Hello World").send();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testUseTwoTimesSameThread() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:echo");
        mock.expectedBodiesReceived(new Object[]{"Camel", "World"});
        ((MockValueBuilder)mock.message(0).header("foo")).isEqualTo((Object)"!");
        ((MockValueBuilder)mock.message(1).header("foo")).isNull();
        FluentProducerTemplate fluent = this.context.createFluentProducerTemplate();
        Object result = fluent.withBody((Object)"Camel").withHeader("foo", (Object)"!").to("direct:echo").request();
        Object result2 = fluent.withBody((Object)"World").to("direct:echo").request();
        Assertions.assertEquals((Object)"CamelCamel!", (Object)result);
        Assertions.assertEquals((Object)"WorldWorld", (Object)result2);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testUseFourTimesSameThread() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:echo");
        mock.expectedBodiesReceived(new Object[]{"Camel", "Beer"});
        ((MockValueBuilder)mock.message(0).header("foo")).isEqualTo((Object)"!");
        ((MockValueBuilder)mock.message(1).header("foo")).isNull();
        FluentProducerTemplate fluent = this.context.createFluentProducerTemplate();
        fluent.setDefaultEndpointUri("direct:red");
        Object result = fluent.withBody((Object)"Camel").withHeader("foo", (Object)"!").to("direct:echo").request();
        Object result2 = fluent.withBody((Object)"World").to("direct:hi").request();
        Object result3 = fluent.withBody((Object)"Beer").to("direct:echo").request();
        Object result4 = fluent.withBody((Object)"Wine").request();
        Assertions.assertEquals((Object)"CamelCamel!", (Object)result);
        Assertions.assertEquals((Object)"Hi World", (Object)result2);
        Assertions.assertEquals((Object)"BeerBeer", (Object)result3);
        Assertions.assertEquals((Object)"Red Wine", (Object)result4);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testPerformance() {
        FluentProducerTemplate fluent = this.context.createFluentProducerTemplate();
        for (int i = 0; i < 1000; ++i) {
            Object result = fluent.withBody((Object)"Camel").withHeader("foo", (Object)("" + i)).to("direct:echo").request();
            Assertions.assertEquals((Object)("CamelCamel" + i), (Object)result);
        }
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.noErrorHandler());
                ((RouteDefinition)this.from("direct:in").process(exchange -> exchange.getIn().setBody((Object)"Bye World"))).to("mock:result");
                ((RouteDefinition)this.from("direct:sum").process(exchange -> {
                    Object body = exchange.getIn().getBody();
                    if (!(body instanceof Integer)) {
                        throw new IllegalArgumentException("Expected body of type Integer");
                    }
                    Integer integer = (Integer)body;
                    exchange.getIn().setBody((Object)(integer + 1));
                })).to("mock:result");
                ((RouteDefinition)this.from("direct:out").process(exchange -> exchange.getMessage().setBody((Object)"Bye Bye World"))).to("mock:result");
                ((RouteDefinition)this.from("direct:exception").process(exchange -> {
                    throw new IllegalArgumentException("Forced exception by unit test");
                })).to("mock:result");
                this.from("direct:inout").transform((Expression)this.constant(123));
                this.from("direct:async").to("mock:async");
                ((RouteDefinition)this.from("direct:echo").to("mock:echo")).setBody().simple("${body}${body}${header.foo}");
                this.from("direct:hi").setBody().simple("Hi ${body}");
                this.from("direct:red").setBody().simple("Red ${body}");
                this.from("direct:var").transform().simple("${body} ${variable.foo}");
                this.from("direct:ep").transform().simple("${body} ${exchangeProperty.foo}");
            }
        };
    }
}

